@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property passwordField Details about your login page password field. See `password_field` for more details.
 * @property payloadType The payload type for your login endpoint, either JSON or form encoded.
 * @property usernameField Details about your login page username field. See `username_field` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs(
    public val passwordField: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgs>,
    public val payloadType: Output<String>,
    public val usernameField: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgs>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs.builder()
            .passwordField(passwordField.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .payloadType(payloadType.applyValue({ args0 -> args0 }))
            .usernameField(usernameField.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgsBuilder
internal constructor() {
    private var passwordField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgs>? =
        null

    private var payloadType: Output<String>? = null

    private var usernameField:
        Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgs>? =
        null

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("cqlgnedcleodlgjb")
    public suspend fun passwordField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgs>) {
        this.passwordField = value
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("elaojscqrlvoirmf")
    public suspend fun payloadType(`value`: Output<String>) {
        this.payloadType = value
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("yqwkqarldsxrbypo")
    public suspend fun usernameField(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgs>) {
        this.usernameField = value
    }

    /**
     * @param value Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("yfimyihfbrhwueto")
    public suspend fun passwordField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwordField = mapped
    }

    /**
     * @param argument Details about your login page password field. See `password_field` for more details.
     */
    @JvmName("tifeocgawgfenwrd")
    public suspend fun passwordField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionPasswordFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.passwordField = mapped
    }

    /**
     * @param value The payload type for your login endpoint, either JSON or form encoded.
     */
    @JvmName("ikbbfaqpfjkmhkbm")
    public suspend fun payloadType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.payloadType = mapped
    }

    /**
     * @param value Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("nvnpjrkwqkgrsxuv")
    public suspend fun usernameField(`value`: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernameField = mapped
    }

    /**
     * @param argument Details about your login page username field. See `username_field` for more details.
     */
    @JvmName("ioxcoaqhdjmdehcq")
    public suspend fun usernameField(argument: suspend WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionUsernameFieldArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.usernameField = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetRequestInspectionArgs(
            passwordField = passwordField ?: throw PulumiNullFieldException("passwordField"),
            payloadType = payloadType ?: throw PulumiNullFieldException("payloadType"),
            usernameField = usernameField ?: throw PulumiNullFieldException("usernameField"),
        )
}
