@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property failureValues Values in the response header with the specified name that indicate a failed login attempt.
 * @property identifier The identifier for the value to match against in the JSON.
 * @property successValues Values in the response header with the specified name that indicate a successful login attempt.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs(
    public val failureValues: Output<List<String>>,
    public val identifier: Output<String>,
    public val successValues: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs.builder()
            .failureValues(failureValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .identifier(identifier.applyValue({ args0 -> args0 }))
            .successValues(successValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgsBuilder
internal constructor() {
    private var failureValues: Output<List<String>>? = null

    private var identifier: Output<String>? = null

    private var successValues: Output<List<String>>? = null

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("gfupxbsnkuksevtl")
    public suspend fun failureValues(`value`: Output<List<String>>) {
        this.failureValues = value
    }

    @JvmName("pumwvmlnlivdqauu")
    public suspend fun failureValues(vararg values: Output<String>) {
        this.failureValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("jjhiqeajerrpfdrd")
    public suspend fun failureValues(values: List<Output<String>>) {
        this.failureValues = Output.all(values)
    }

    /**
     * @param value The identifier for the value to match against in the JSON.
     */
    @JvmName("hfiasnhshuiviamg")
    public suspend fun identifier(`value`: Output<String>) {
        this.identifier = value
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("uvmbpnuqbbpqvdfd")
    public suspend fun successValues(`value`: Output<List<String>>) {
        this.successValues = value
    }

    @JvmName("iubdcfsdugwrhvhw")
    public suspend fun successValues(vararg values: Output<String>) {
        this.successValues = Output.all(values.asList())
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("pibyqjtijhifayqt")
    public suspend fun successValues(values: List<Output<String>>) {
        this.successValues = Output.all(values)
    }

    /**
     * @param value Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("xxghwfvhtrersysi")
    public suspend fun failureValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a failed login attempt.
     */
    @JvmName("eyrxunfmaceywnkg")
    public suspend fun failureValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failureValues = mapped
    }

    /**
     * @param value The identifier for the value to match against in the JSON.
     */
    @JvmName("kvfeumhfhhlkfkhu")
    public suspend fun identifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param value Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("levsesbtpdduolxq")
    public suspend fun successValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    /**
     * @param values Values in the response header with the specified name that indicate a successful login attempt.
     */
    @JvmName("hytgkqiakankwdqk")
    public suspend fun successValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successValues = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSetResponseInspectionJsonArgs(
            failureValues = failureValues ?: throw PulumiNullFieldException("failureValues"),
            identifier = identifier ?: throw PulumiNullFieldException("identifier"),
            successValues = successValues ?: throw PulumiNullFieldException("successValues"),
        )
}
