@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableMachineLearning Applies only to the targeted inspection level. Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Defaults to `true`.
 * @property inspectionLevel The inspection level to use for the Bot Control rule group.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs(
    public val enableMachineLearning: Output<Boolean>? = null,
    public val inspectionLevel: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs.builder()
            .enableMachineLearning(enableMachineLearning?.applyValue({ args0 -> args0 }))
            .inspectionLevel(inspectionLevel.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgsBuilder
internal constructor() {
    private var enableMachineLearning: Output<Boolean>? = null

    private var inspectionLevel: Output<String>? = null

    /**
     * @param value Applies only to the targeted inspection level. Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Defaults to `true`.
     */
    @JvmName("gsseldjlgyciuqyk")
    public suspend fun enableMachineLearning(`value`: Output<Boolean>) {
        this.enableMachineLearning = value
    }

    /**
     * @param value The inspection level to use for the Bot Control rule group.
     */
    @JvmName("qaspmxxjtypneoje")
    public suspend fun inspectionLevel(`value`: Output<String>) {
        this.inspectionLevel = value
    }

    /**
     * @param value Applies only to the targeted inspection level. Determines whether to use machine learning (ML) to analyze your web traffic for bot-related activity. Defaults to `true`.
     */
    @JvmName("qvmacqfuyvtkrrlv")
    public suspend fun enableMachineLearning(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableMachineLearning = mapped
    }

    /**
     * @param value The inspection level to use for the Bot Control rule group.
     */
    @JvmName("herggeyoiptamqyd")
    public suspend fun inspectionLevel(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inspectionLevel = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs =
        WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSetArgs(
            enableMachineLearning = enableMachineLearning,
            inspectionLevel = inspectionLevel ?: throw PulumiNullFieldException("inspectionLevel"),
        )
}
