@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customResponseBodyKey References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
 * @property responseCode The HTTP status code to return to the client.
 * @property responseHeaders The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs(
    public val customResponseBodyKey: Output<String>? = null,
    public val responseCode: Output<Int>,
    public val responseHeaders: Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs.builder()
            .customResponseBodyKey(customResponseBodyKey?.applyValue({ args0 -> args0 }))
            .responseCode(responseCode.applyValue({ args0 -> args0 }))
            .responseHeaders(
                responseHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgsBuilder
internal constructor() {
    private var customResponseBodyKey: Output<String>? = null

    private var responseCode: Output<Int>? = null

    private var responseHeaders:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>? =
        null

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("wrklobmsebompqak")
    public suspend fun customResponseBodyKey(`value`: Output<String>) {
        this.customResponseBodyKey = value
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("abwsxyclbcyiihyf")
    public suspend fun responseCode(`value`: Output<Int>) {
        this.responseCode = value
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("jisprfndbwkrugdd")
    public suspend fun responseHeaders(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = value
    }

    @JvmName("qfjkcglrtjidsykc")
    public suspend fun responseHeaders(vararg values: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>) {
        this.responseHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("rkdhlkqwgbpexcqn")
    public suspend fun responseHeaders(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = Output.all(values)
    }

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("ipmlhxxkaaptowfx")
    public suspend fun customResponseBodyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodyKey = mapped
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("trffnmpdheykuxby")
    public suspend fun responseCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseCode = mapped
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("uckfolcmkibnejqw")
    public suspend fun responseHeaders(`value`: List<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("jvuhumbwdyxjhwvh")
    public suspend fun responseHeaders(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("tpqweapnhvdlmnto")
    public suspend fun responseHeaders(vararg argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("unyqpyfeiuqwewvu")
    public suspend fun responseHeaders(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("hwarbhtoxrefmaal")
    public suspend fun responseHeaders(vararg values: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs =
        WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseBlockCustomResponseArgs(
            customResponseBodyKey = customResponseBodyKey,
            responseCode = responseCode ?: throw PulumiNullFieldException("responseCode"),
            responseHeaders = responseHeaders,
        )
}
