@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actionToUse Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
 * @property name Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs(
    public val actionToUse: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs.builder()
            .actionToUse(actionToUse.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgsBuilder internal constructor() {
    private var actionToUse:
        Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("qvikxsuknsoxdlpr")
    public suspend fun actionToUse(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs>) {
        this.actionToUse = value
    }

    /**
     * @param value Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
     */
    @JvmName("kqywyoyhcplaseof")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("pkylirlbepkxidvw")
    public suspend fun actionToUse(`value`: WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionToUse = mapped
    }

    /**
     * @param argument Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("xsbgmhmkiawivwbp")
    public suspend fun actionToUse(argument: suspend WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideActionToUseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actionToUse = mapped
    }

    /**
     * @param value Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
     */
    @JvmName("gyempaamwbtdybew")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs =
        WebAclRuleStatementManagedRuleGroupStatementRuleActionOverrideArgs(
            actionToUse = actionToUse ?: throw PulumiNullFieldException("actionToUse"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
