@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs(
    public val andStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs>? =
        null,
    public val byteMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgs>? =
        null,
    public val geoMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs>? =
        null,
    public val ipSetReferenceStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null,
    public val labelMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs>? =
        null,
    public val notStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgs>? =
        null,
    public val orStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs>? = null,
    public val regexMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgs>? =
        null,
    public val regexPatternSetReferenceStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null,
    public val sizeConstraintStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null,
    public val sqliMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgs>? =
        null,
    public val xssMatchStatement: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs.builder()
            .andStatement(andStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .byteMatchStatement(
                byteMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .geoMatchStatement(geoMatchStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipSetReferenceStatement(
                ipSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .labelMatchStatement(
                labelMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notStatement(notStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .orStatement(orStatement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexMatchStatement(
                regexMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .regexPatternSetReferenceStatement(
                regexPatternSetReferenceStatement?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sizeConstraintStatement(
                sizeConstraintStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sqliMatchStatement(
                sqliMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .xssMatchStatement(
                xssMatchStatement?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgsBuilder internal constructor() {
    private var andStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs>? = null

    private var byteMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgs>? =
        null

    private var geoMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs>? =
        null

    private var ipSetReferenceStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs>? =
        null

    private var labelMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs>? =
        null

    private var notStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgs>? = null

    private var orStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs>? = null

    private var regexMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgs>? =
        null

    private var regexPatternSetReferenceStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>? =
        null

    private var sizeConstraintStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgs>? =
        null

    private var sqliMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgs>? =
        null

    private var xssMatchStatement:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgs>? =
        null

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("vferyrkadexrfruf")
    public suspend fun andStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs>) {
        this.andStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("bdfsjnrjdvlywoty")
    public suspend fun byteMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgs>) {
        this.byteMatchStatement = value
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("ocqdksdfjsbjihix")
    public suspend fun geoMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs>) {
        this.geoMatchStatement = value
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("juijrpaqhingxkgt")
    public suspend fun ipSetReferenceStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs>) {
        this.ipSetReferenceStatement = value
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("htdujxsjwefmltlk")
    public suspend fun labelMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs>) {
        this.labelMatchStatement = value
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("nkdtronyjqyfaxwj")
    public suspend fun notStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgs>) {
        this.notStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("utlldtwaxosnegyu")
    public suspend fun orStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs>) {
        this.orStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("fnhofglcvmvobkgf")
    public suspend fun regexMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgs>) {
        this.regexMatchStatement = value
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("imsghwawysyjnsah")
    public suspend fun regexPatternSetReferenceStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgs>) {
        this.regexPatternSetReferenceStatement = value
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("btgohwaiwhkpwqct")
    public suspend fun sizeConstraintStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgs>) {
        this.sizeConstraintStatement = value
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("qvygkcfaamcalpec")
    public suspend fun sqliMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgs>) {
        this.sqliMatchStatement = value
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("yqpyocqfuhjfbyuh")
    public suspend fun xssMatchStatement(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgs>) {
        this.xssMatchStatement = value
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("amdydmvvkxxugrwp")
    public suspend fun andStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.andStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
     */
    @JvmName("blgqescaekcprotf")
    public suspend fun andStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.andStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("gwafxspbqsvrrsrm")
    public suspend fun byteMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.byteMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
     */
    @JvmName("pnafyherjpkgywbj")
    public suspend fun byteMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.byteMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("puqqryxfktjwnuut")
    public suspend fun geoMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
     */
    @JvmName("ylebqnruxaaqdcna")
    public suspend fun geoMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.geoMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("miksexceiyheglth")
    public suspend fun ipSetReferenceStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
     */
    @JvmName("kpyyddpmotswhilm")
    public suspend fun ipSetReferenceStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ipSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("ycnjvgnlramspdug")
    public suspend fun labelMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
     */
    @JvmName("wnvwpnecgmmqddir")
    public suspend fun labelMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelMatchStatement = mapped
    }

    /**
     * @param value Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("lyxirigiakbrhkun")
    public suspend fun notStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
     */
    @JvmName("dlxtltbokqrrqjes")
    public suspend fun notStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.notStatement = mapped
    }

    /**
     * @param value Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("wfyyqruflbbslaus")
    public suspend fun orStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.orStatement = mapped
    }

    /**
     * @param argument Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
     */
    @JvmName("ylnffkcokeuwfjub")
    public suspend fun orStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.orStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("nrnbsmxcjlvrxoxa")
    public suspend fun regexMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexMatchStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
     */
    @JvmName("fsgofaiqlemvnikw")
    public suspend fun regexMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexMatchStatement = mapped
    }

    /**
     * @param value Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("bdbcrscffadgejgg")
    public suspend fun regexPatternSetReferenceStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param argument Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
     */
    @JvmName("fyorqwjocuqqjtcc")
    public suspend fun regexPatternSetReferenceStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.regexPatternSetReferenceStatement = mapped
    }

    /**
     * @param value Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("ggibgmnqqsfdrory")
    public suspend fun sizeConstraintStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param argument Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
     */
    @JvmName("dododhtklicesiuo")
    public suspend fun sizeConstraintStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sizeConstraintStatement = mapped
    }

    /**
     * @param value An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("dlqcsxlqpmnfxwcu")
    public suspend fun sqliMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqliMatchStatement = mapped
    }

    /**
     * @param argument An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
     */
    @JvmName("butywhhiivckcvhi")
    public suspend fun sqliMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sqliMatchStatement = mapped
    }

    /**
     * @param value Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("swsuqddkxxcmkyka")
    public suspend fun xssMatchStatement(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.xssMatchStatement = mapped
    }

    /**
     * @param argument Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
     */
    @JvmName("nprygndyuqusyhjt")
    public suspend fun xssMatchStatement(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.xssMatchStatement = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementArgs(
            andStatement = andStatement,
            byteMatchStatement = byteMatchStatement,
            geoMatchStatement = geoMatchStatement,
            ipSetReferenceStatement = ipSetReferenceStatement,
            labelMatchStatement = labelMatchStatement,
            notStatement = notStatement,
            orStatement = orStatement,
            regexMatchStatement = regexMatchStatement,
            regexPatternSetReferenceStatement = regexPatternSetReferenceStatement,
            sizeConstraintStatement = sizeConstraintStatement,
            sqliMatchStatement = sqliMatchStatement,
            xssMatchStatement = xssMatchStatement,
        )
}
