@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property countryCodes Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
 * @property forwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs(
    public val countryCodes: Output<List<String>>,
    public val forwardedIpConfig: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs.builder()
            .countryCodes(countryCodes.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .forwardedIpConfig(
                forwardedIpConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgsBuilder
internal constructor() {
    private var countryCodes: Output<List<String>>? = null

    private var forwardedIpConfig:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>? =
        null

    /**
     * @param value Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("cfparsxdcrixfquu")
    public suspend fun countryCodes(`value`: Output<List<String>>) {
        this.countryCodes = value
    }

    @JvmName("nqddmcjflasltqos")
    public suspend fun countryCodes(vararg values: Output<String>) {
        this.countryCodes = Output.all(values.asList())
    }

    /**
     * @param values Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("oljjuchkjnunbulg")
    public suspend fun countryCodes(values: List<Output<String>>) {
        this.countryCodes = Output.all(values)
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("rvraheikwgvcqyag")
    public suspend fun forwardedIpConfig(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs>) {
        this.forwardedIpConfig = value
    }

    /**
     * @param value Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("mjrvrrpvyxqyuvai")
    public suspend fun countryCodes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param values Array of two-character country codes, for example, [ "US", "CN" ], from the alpha-2 country ISO codes of the `ISO 3166` international standard&#46; See the [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_GeoMatchStatement.html) for valid values.
     */
    @JvmName("kcmskvqdpeybuiec")
    public suspend fun countryCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.countryCodes = mapped
    }

    /**
     * @param value Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("xrwojjupqcwvhcim")
    public suspend fun forwardedIpConfig(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIpConfig = mapped
    }

    /**
     * @param argument Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `forwarded_ip_config` below for details.
     */
    @JvmName("snudrqynvdhfudlq")
    public suspend fun forwardedIpConfig(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementForwardedIpConfigArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIpConfig = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatementArgs(
            countryCodes = countryCodes ?: throw PulumiNullFieldException("countryCodes"),
            forwardedIpConfig = forwardedIpConfig,
        )
}
