@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property statements The statements to combine.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs(
    public val statements: Output<List<WebAclRuleStatementArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs.builder()
            .statements(
                statements.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgsBuilder
internal constructor() {
    private var statements: Output<List<WebAclRuleStatementArgs>>? = null

    /**
     * @param value The statements to combine.
     */
    @JvmName("luakaegodqcicvdt")
    public suspend fun statements(`value`: Output<List<WebAclRuleStatementArgs>>) {
        this.statements = value
    }

    @JvmName("cpuqgpbdgiatnako")
    public suspend fun statements(vararg values: Output<WebAclRuleStatementArgs>) {
        this.statements = Output.all(values.asList())
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("gyhdniftyudeyqlt")
    public suspend fun statements(values: List<Output<WebAclRuleStatementArgs>>) {
        this.statements = Output.all(values)
    }

    /**
     * @param value The statements to combine.
     */
    @JvmName("hoyekrehqejvrcen")
    public suspend fun statements(`value`: List<WebAclRuleStatementArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("ipmjpexgsratyjwm")
    public suspend fun statements(argument: List<suspend WebAclRuleStatementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("hgsrhhlxojvqtanh")
    public suspend fun statements(vararg argument: suspend WebAclRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param argument The statements to combine.
     */
    @JvmName("myqlngllhgodxstp")
    public suspend fun statements(argument: suspend WebAclRuleStatementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebAclRuleStatementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.statements = mapped
    }

    /**
     * @param values The statements to combine.
     */
    @JvmName("vaydtmixkyfqqfdv")
    public suspend fun statements(vararg values: WebAclRuleStatementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statements = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatementArgs(
            statements = statements ?: throw PulumiNullFieldException("statements"),
        )
}
