@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headerOrders Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs(
    public val allQueryArguments: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>>? =
        null,
    public val headers: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder
internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>? =
        null

    private var cookies:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>>? =
        null

    private var headers:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ubgibmdoidamebms")
    public suspend fun allQueryArguments(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("ncgrkmrnrcxmrseu")
    public suspend fun body(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("lxqutqigqdthixtx")
    public suspend fun cookies(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("lxsmlnhmgyqoagec")
    public suspend fun headerOrders(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("bxkbjplakjbuqwhs")
    public suspend fun headerOrders(vararg values: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("ggysgxlxkdyhvodj")
    public suspend fun headerOrders(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("jgntbbhckdyiuohe")
    public suspend fun headers(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("mqywhwcgqhtsspvp")
    public suspend fun headers(vararg values: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("qpcdfcvsjykkjuwh")
    public suspend fun headers(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("dtwhqlnyirvnnjde")
    public suspend fun ja3Fingerprint(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("eepdvmnmeeqighol")
    public suspend fun jsonBody(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("gaqgcjkpakudtdsh")
    public suspend fun method(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("nognikxjqavkvonw")
    public suspend fun queryString(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("kcgdwoqjbhedhvvx")
    public suspend fun singleHeader(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("wecjnltaqvsyvcjv")
    public suspend fun singleQueryArgument(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("myllthwjoqpubedb")
    public suspend fun uriPath(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("hugdspekermmmtuk")
    public suspend fun allQueryArguments(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("yysirgjbmxigftcs")
    public suspend fun allQueryArguments(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("kdkcbastnrhmdksw")
    public suspend fun body(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("oojyapwiyqgsmekr")
    public suspend fun body(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("kkawycaitdcqrocj")
    public suspend fun cookies(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("uhkprhuoeaytjutv")
    public suspend fun cookies(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("aqjgwksbfpxshxcv")
    public suspend fun headerOrders(`value`: List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("fuabkdrlpjnwshsd")
    public suspend fun headerOrders(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("mcmfxudsjlqxvyjy")
    public suspend fun headerOrders(vararg argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("geikeuyjlgjsunwk")
    public suspend fun headerOrders(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("kljvurnwjmsddcwh")
    public suspend fun headerOrders(vararg values: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vyigdfbwveqlrbea")
    public suspend fun headers(`value`: List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("uovspqhfyliqebag")
    public suspend fun headers(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("btxdnoowwrrewnia")
    public suspend fun headers(vararg argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("cgxwgmehdxxesjga")
    public suspend fun headers(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("iryikkvetjvjvpve")
    public suspend fun headers(vararg values: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("ufyayxucjycjetcu")
    public suspend fun ja3Fingerprint(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("klcvjfnkoeyigqgr")
    public suspend fun ja3Fingerprint(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("jjteqvtjhbwhjfqn")
    public suspend fun jsonBody(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("imqogcnnqngxvxfm")
    public suspend fun jsonBody(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("rdxsxokhooqrsvcb")
    public suspend fun method(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("spdcitwicwweffbt")
    public suspend fun method(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("bndcwjalrabjwfua")
    public suspend fun queryString(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("peljgekvovqnpwcr")
    public suspend fun queryString(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("plbvivxqlmqfitdd")
    public suspend fun singleHeader(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("xyufwkpxfooinexs")
    public suspend fun singleHeader(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("qwaxaynmlgvepchv")
    public suspend fun singleQueryArgument(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("gbpgphlqwpajcoow")
    public suspend fun singleQueryArgument(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("asigdrgengrashnq")
    public suspend fun uriPath(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("cqaodyxsfqnpdgdt")
    public suspend fun uriPath(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
