@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headerOrders Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs(
    public val allQueryArguments: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>>? =
        null,
    public val headers: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgsBuilder
internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgs>? =
        null

    private var cookies:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>>? =
        null

    private var headers:
        Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("vllwgkftobtnxofa")
    public suspend fun allQueryArguments(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("ayqreldgowydfywr")
    public suspend fun body(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("mtmlcbxagedkgjlv")
    public suspend fun cookies(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("lytwdeenbvknsang")
    public suspend fun headerOrders(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("prrwvbxkjmsoogyp")
    public suspend fun headerOrders(vararg values: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("yiqcbnnbqyeaddho")
    public suspend fun headerOrders(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("dfqybnrgkotevdww")
    public suspend fun headers(`value`: Output<List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("crsojtabqhcrxmyh")
    public suspend fun headers(vararg values: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("svuvrrkmapmhrhee")
    public suspend fun headers(values: List<Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("omutqdutirmfsnxf")
    public suspend fun ja3Fingerprint(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("gdsljvdtotfqjbyj")
    public suspend fun jsonBody(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("nfslobbngvjdkeuy")
    public suspend fun method(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("rfjhosaexqgolxaq")
    public suspend fun queryString(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("xrfmhjxqysphvqfu")
    public suspend fun singleHeader(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("pybjllqtpmenidne")
    public suspend fun singleQueryArgument(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("jussaenoqbualsfe")
    public suspend fun uriPath(`value`: Output<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("xipjboyjvgewxvin")
    public suspend fun allQueryArguments(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("higkdwruvjjvfojt")
    public suspend fun allQueryArguments(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("ldhkkdloupnggcxi")
    public suspend fun body(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("yjdpppsvcrhtaskf")
    public suspend fun body(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("cnqrcsgyheuwlnhw")
    public suspend fun cookies(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("yoncphckctqeegcy")
    public suspend fun cookies(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("yhrodqsbjpuqmhap")
    public suspend fun headerOrders(`value`: List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("lhndwomqppwcsudp")
    public suspend fun headerOrders(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("ukjlomywhegcjqdi")
    public suspend fun headerOrders(vararg argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("rirdjlhiujmixncc")
    public suspend fun headerOrders(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("dbgxkibqqjxxogit")
    public suspend fun headerOrders(vararg values: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("kabuewopmgekiwxq")
    public suspend fun headers(`value`: List<WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("kwvqtuwrhnwbhiyb")
    public suspend fun headers(argument: List<suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("xptnydeafxavkrbr")
    public suspend fun headers(vararg argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("heiryxxkylrsrhao")
    public suspend fun headers(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vouxwtipsmaeopcx")
    public suspend fun headers(vararg values: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("mtytonephmijujln")
    public suspend fun ja3Fingerprint(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("sxkefdduvwiuhruj")
    public suspend fun ja3Fingerprint(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("fjegljjthmdktshg")
    public suspend fun jsonBody(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("dpjtrjhxrhgqudch")
    public suspend fun jsonBody(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("boyisuositcaycst")
    public suspend fun method(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("sldkdnhitmubwchc")
    public suspend fun method(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("hrhuhghfpglesogt")
    public suspend fun queryString(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("seopdkdacbaryfre")
    public suspend fun queryString(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("kagepbanrwmfgvyg")
    public suspend fun singleHeader(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("emyysvvimnrarcfp")
    public suspend fun singleHeader(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("ohrsggliqunjqhsm")
    public suspend fun singleQueryArgument(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("uyodnavpeotxjqml")
    public suspend fun singleQueryArgument(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("rqgtojstvpcivbkk")
    public suspend fun uriPath(`value`: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("rrjyyicaakgbkeas")
    public suspend fun uriPath(argument: suspend WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs =
        WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
