@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cookie Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
 * @property forwardedIp Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
 * @property header Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
 * @property httpMethod Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
 * @property ip Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
 * @property labelNamespace Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
 * @property queryArgument Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
 * @property queryString Use the request's query string as an aggregate key. See RateLimit `query_string` below for details.
 * @property uriPath Use the request's URI path as an aggregate key. See RateLimit `uri_path` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyArgs(
    public val cookie: Output<WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs>? = null,
    public val forwardedIp: Output<WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>? =
        null,
    public val `header`: Output<WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs>? = null,
    public val httpMethod: Output<WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>? =
        null,
    public val ip: Output<WebAclRuleStatementRateBasedStatementCustomKeyIpArgs>? = null,
    public val labelNamespace: Output<WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>? = null,
    public val queryArgument: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>? =
        null,
    public val queryString: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs>? =
        null,
    public val uriPath: Output<WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyArgs.builder()
            .cookie(cookie?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .forwardedIp(forwardedIp?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`header`(`header`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .httpMethod(httpMethod?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ip(ip?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labelNamespace(labelNamespace?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryArgument(queryArgument?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyArgsBuilder internal constructor() {
    private var cookie: Output<WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs>? = null

    private var forwardedIp: Output<WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>? =
        null

    private var `header`: Output<WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs>? = null

    private var httpMethod: Output<WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>? =
        null

    private var ip: Output<WebAclRuleStatementRateBasedStatementCustomKeyIpArgs>? = null

    private var labelNamespace:
        Output<WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>? = null

    private var queryArgument:
        Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>? = null

    private var queryString: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs>? =
        null

    private var uriPath: Output<WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs>? = null

    /**
     * @param value Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("resfblflyondxgfi")
    public suspend fun cookie(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs>) {
        this.cookie = value
    }

    /**
     * @param value Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("lusxfoyrixvnpvar")
    public suspend fun forwardedIp(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgs>) {
        this.forwardedIp = value
    }

    /**
     * @param value Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("bxvenbxbgeoromel")
    public suspend fun `header`(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs>) {
        this.`header` = value
    }

    /**
     * @param value Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("qownifyiulxqncll")
    public suspend fun httpMethod(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgs>) {
        this.httpMethod = value
    }

    /**
     * @param value Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("rpayvvjihvfepvph")
    public suspend fun ip(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyIpArgs>) {
        this.ip = value
    }

    /**
     * @param value Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("nrumavbfnndgwrfv")
    public suspend fun labelNamespace(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs>) {
        this.labelNamespace = value
    }

    /**
     * @param value Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("lgvkrbjgyeivpjmy")
    public suspend fun queryArgument(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs>) {
        this.queryArgument = value
    }

    /**
     * @param value Use the request's query string as an aggregate key. See RateLimit `query_string` below for details.
     */
    @JvmName("qfylhpktrjmbxivh")
    public suspend fun queryString(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Use the request's URI path as an aggregate key. See RateLimit `uri_path` below for details.
     */
    @JvmName("llmypryanylyhbic")
    public suspend fun uriPath(`value`: Output<WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("pwbmkwlowfsncqsy")
    public suspend fun cookie(`value`: WebAclRuleStatementRateBasedStatementCustomKeyCookieArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookie = mapped
    }

    /**
     * @param argument Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
     */
    @JvmName("tsbgbuameoeawcsa")
    public suspend fun cookie(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRateBasedStatementCustomKeyCookieArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cookie = mapped
    }

    /**
     * @param value Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("wpcqgfjfbdpaqibr")
    public suspend fun forwardedIp(`value`: WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardedIp = mapped
    }

    /**
     * @param argument Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
     */
    @JvmName("wxkqwagymerkighd")
    public suspend fun forwardedIp(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyForwardedIpArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.forwardedIp = mapped
    }

    /**
     * @param value Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("jwipqvdhtvkcccrn")
    public suspend fun `header`(`value`: WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`header` = mapped
    }

    /**
     * @param argument Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
     */
    @JvmName("oetvkrkoervoiibw")
    public suspend fun `header`(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRateBasedStatementCustomKeyHeaderArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.`header` = mapped
    }

    /**
     * @param value Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("lweqpeyjjshkbwtb")
    public suspend fun httpMethod(`value`: WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpMethod = mapped
    }

    /**
     * @param argument Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
     */
    @JvmName("onkpeokidikdrmws")
    public suspend fun httpMethod(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyHttpMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.httpMethod = mapped
    }

    /**
     * @param value Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("qtjstqxvjeygqylo")
    public suspend fun ip(`value`: WebAclRuleStatementRateBasedStatementCustomKeyIpArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ip = mapped
    }

    /**
     * @param argument Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
     */
    @JvmName("niiailmdwjwqpoqm")
    public suspend fun ip(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyIpArgsBuilder.() -> Unit) {
        val toBeMapped = WebAclRuleStatementRateBasedStatementCustomKeyIpArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ip = mapped
    }

    /**
     * @param value Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("rsaggavnihlropeg")
    public suspend fun labelNamespace(`value`: WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelNamespace = mapped
    }

    /**
     * @param argument Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
     */
    @JvmName("iauneeshqthaqfpa")
    public suspend fun labelNamespace(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespaceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.labelNamespace = mapped
    }

    /**
     * @param value Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("cwyyntlsdfjjyqnt")
    public suspend fun queryArgument(`value`: WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryArgument = mapped
    }

    /**
     * @param argument Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
     */
    @JvmName("cfsqodpdpbnejdqt")
    public suspend fun queryArgument(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryArgument = mapped
    }

    /**
     * @param value Use the request's query string as an aggregate key. See RateLimit `query_string` below for details.
     */
    @JvmName("ckffonnuvtaomjnd")
    public suspend fun queryString(`value`: WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Use the request's query string as an aggregate key. See RateLimit `query_string` below for details.
     */
    @JvmName("qunhjixedfoblkmk")
    public suspend fun queryString(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Use the request's URI path as an aggregate key. See RateLimit `uri_path` below for details.
     */
    @JvmName("wxuhiqjfvsthvqul")
    public suspend fun uriPath(`value`: WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Use the request's URI path as an aggregate key. See RateLimit `uri_path` below for details.
     */
    @JvmName("ywngxuhkryqxondi")
    public suspend fun uriPath(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementCustomKeyUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyArgs(
            cookie = cookie,
            forwardedIp = forwardedIp,
            `header` = `header`,
            httpMethod = httpMethod,
            ip = ip,
            labelNamespace = labelNamespace,
            queryArgument = queryArgument,
            queryString = queryString,
            uriPath = uriPath,
        )
}
