@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the query argument to use.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs(
    public val name: Output<String>,
    public val textTransformations: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>? =
        null

    /**
     * @param value The name of the query argument to use.
     */
    @JvmName("nupeccofnfrrymqj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("buskesarkluytfbc")
    public suspend fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("bhjdoebqrexjyccd")
    public suspend fun textTransformations(vararg values: Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("yblhukfkkwhnxjch")
    public suspend fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The name of the query argument to use.
     */
    @JvmName("nhifcqbqjxpqkrcd")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("dorxhqvsvksxdntk")
    public suspend fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("qwbjxfykwobpyppu")
    public suspend fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("mesvfuqrrmitvfpf")
    public suspend fun textTransformations(vararg argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("htfvrtvjgbeduuyf")
    public suspend fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
     */
    @JvmName("qkskidceiheylvdi")
    public suspend fun textTransformations(vararg values: WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs =
        WebAclRuleStatementRateBasedStatementCustomKeyQueryArgumentArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
