@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fallbackBehavior Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
 * @property headerName Name of the HTTP header to use for the IP address.
 */
public data class WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs(
    public val fallbackBehavior: Output<String>,
    public val headerName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs.builder()
            .fallbackBehavior(fallbackBehavior.applyValue({ args0 -> args0 }))
            .headerName(headerName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementForwardedIpConfigArgsBuilder internal constructor() {
    private var fallbackBehavior: Output<String>? = null

    private var headerName: Output<String>? = null

    /**
     * @param value Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("ctmehrqujeoufisg")
    public suspend fun fallbackBehavior(`value`: Output<String>) {
        this.fallbackBehavior = value
    }

    /**
     * @param value Name of the HTTP header to use for the IP address.
     */
    @JvmName("sxpyllifietirauc")
    public suspend fun headerName(`value`: Output<String>) {
        this.headerName = value
    }

    /**
     * @param value Match status to assign to the web request if the request doesn't have a valid IP address in the specified position. Valid values include: `MATCH` or `NO_MATCH`.
     */
    @JvmName("issxsqhmcpltuvnu")
    public suspend fun fallbackBehavior(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fallbackBehavior = mapped
    }

    /**
     * @param value Name of the HTTP header to use for the IP address.
     */
    @JvmName("mulcamhmrsfprlee")
    public suspend fun headerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerName = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs =
        WebAclRuleStatementRateBasedStatementForwardedIpConfigArgs(
            fallbackBehavior = fallbackBehavior ?: throw PulumiNullFieldException("fallbackBehavior"),
            headerName = headerName ?: throw PulumiNullFieldException("headerName"),
        )
}
