@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property regexString String representing the regular expression. Minimum of `1` and maximum of `512` characters.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs(
    public val fieldToMatch: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgs>? =
        null,
    public val regexString: Output<String>,
    public val textTransformations: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .regexString(regexString.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgsBuilder
internal constructor() {
    private var fieldToMatch:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgs>? =
        null

    private var regexString: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>>? =
        null

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("tgfevxxdblvnncsj")
    public suspend fun fieldToMatch(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value String representing the regular expression. Minimum of `1` and maximum of `512` characters.
     */
    @JvmName("ktgnybwawgpprkvo")
    public suspend fun regexString(`value`: Output<String>) {
        this.regexString = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mqdaabyupahumvta")
    public suspend fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("fcxseogrgsyocqtg")
    public suspend fun textTransformations(vararg values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("mgjcinossvopeehx")
    public suspend fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("hpxqmhaoaqaoxnia")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument The part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("kefhmtukgglvmvml")
    public suspend fun fieldToMatch(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value String representing the regular expression. Minimum of `1` and maximum of `512` characters.
     */
    @JvmName("cvkhfdnwrqswghqa")
    public suspend fun regexString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexString = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("xmkbxucqnwepoedp")
    public suspend fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("epnxmyjilwvpkpmw")
    public suspend fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("iisvkhfuydussvbl")
    public suspend fun textTransformations(vararg argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("aelexmdejxgabgsl")
    public suspend fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("wtheetuomcddwxmm")
    public suspend fun textTransformations(vararg values: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            regexString = regexString ?: throw PulumiNullFieldException("regexString"),
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
