@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property all An empty configuration block that is used for inspecting all headers.
 * @property excludedHeaders An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
 * @property includedHeaders An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
 */
public data class
WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs(
    public val all: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null,
    public val excludedHeaders: Output<List<String>>? = null,
    public val includedHeaders: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs.builder()
            .all(all?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .excludedHeaders(excludedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includedHeaders(includedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgsBuilder
internal constructor() {
    private var all:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgs>? =
        null

    private var excludedHeaders: Output<List<String>>? = null

    private var includedHeaders: Output<List<String>>? = null

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("knykxpsvpnpxgvav")
    public suspend fun all(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgs>) {
        this.all = value
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("rbsijhtvyflyqsnd")
    public suspend fun excludedHeaders(`value`: Output<List<String>>) {
        this.excludedHeaders = value
    }

    @JvmName("efwgoasifkorydbm")
    public suspend fun excludedHeaders(vararg values: Output<String>) {
        this.excludedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("yvdribhowfatsoki")
    public suspend fun excludedHeaders(values: List<Output<String>>) {
        this.excludedHeaders = Output.all(values)
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("glepxbqhephkdxuk")
    public suspend fun includedHeaders(`value`: Output<List<String>>) {
        this.includedHeaders = value
    }

    @JvmName("iqvjjvnpdgganfpn")
    public suspend fun includedHeaders(vararg values: Output<String>) {
        this.includedHeaders = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("fgbkygahblfucgey")
    public suspend fun includedHeaders(values: List<Output<String>>) {
        this.includedHeaders = Output.all(values)
    }

    /**
     * @param value An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("iltuspbqqkvlwkdx")
    public suspend fun all(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.all = mapped
    }

    /**
     * @param argument An empty configuration block that is used for inspecting all headers.
     */
    @JvmName("caethhonlytvvuod")
    public suspend fun all(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternAllArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.all = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("ptyjefyyapkxoevo")
    public suspend fun excludedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that do not have a key that matches one of the provided values.
     */
    @JvmName("dkivvaanntalytcy")
    public suspend fun excludedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedHeaders = mapped
    }

    /**
     * @param value An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("rfsugcsbraebfebo")
    public suspend fun includedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    /**
     * @param values An array of strings that will be used for inspecting headers that have a key that matches one of the provided values.
     */
    @JvmName("rngfeulfxcitljct")
    public suspend fun includedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.includedHeaders = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatementFieldToMatchHeaderMatchPatternArgs(
            all = all,
            excludedHeaders = excludedHeaders,
            includedHeaders = includedHeaders,
        )
}
