@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class
WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val fieldToMatch: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? =
        null,
    public val textTransformations: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgsBuilder
internal constructor() {
    private var arn: Output<String>? = null

    private var fieldToMatch:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? =
        null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("rcpytubfvnwoddao")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("ludbrmcqmutjbrod")
    public suspend fun fieldToMatch(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("vgdaaearlmjabnxu")
    public suspend fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("yhdyeekrdxjpsskf")
    public suspend fun textTransformations(vararg values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ngjpibbjuqpaseeo")
    public suspend fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("cncqqyfibhlbctnh")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("imkanjpfphkwgsfc")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("xyphjptpnqrnqnov")
    public suspend fun fieldToMatch(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("fcpnddodqvtafgra")
    public suspend fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("wptstmwppjapicox")
    public suspend fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("lnnjlhfcinmasrat")
    public suspend fun textTransformations(vararg argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("usuxldtmsqduvaok")
    public suspend fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("jssipabqaymnewon")
    public suspend fun textTransformations(vararg values: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
