@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property sensitivityLevel Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs(
    public val fieldToMatch: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs>? =
        null,
    public val sensitivityLevel: Output<String>? = null,
    public val textTransformations: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs.builder()
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sensitivityLevel(sensitivityLevel?.applyValue({ args0 -> args0 }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgsBuilder
internal constructor() {
    private var fieldToMatch:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs>? =
        null

    private var sensitivityLevel: Output<String>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>>? =
        null

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("elkvyvhocranlyqi")
    public suspend fun fieldToMatch(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
     */
    @JvmName("pnvjohhqonofcjjp")
    public suspend fun sensitivityLevel(`value`: Output<String>) {
        this.sensitivityLevel = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ydgqmrbhukfyjtbj")
    public suspend fun textTransformations(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("apcesyqaagpeejxi")
    public suspend fun textTransformations(vararg values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("bsesinwsjovcttyn")
    public suspend fun textTransformations(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("qdcnpdnmfkofnmms")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("qcxcpdrjxmsqrvhn")
    public suspend fun fieldToMatch(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
     */
    @JvmName("fbbwuofwvrqhfeif")
    public suspend fun sensitivityLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensitivityLevel = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("gtewbsfaoqubejqf")
    public suspend fun textTransformations(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("giifmyqqqvwcsdkx")
    public suspend fun textTransformations(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("nnuosxrrclmqfpev")
    public suspend fun textTransformations(vararg argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ucchlsyxmytkpsut")
    public suspend fun textTransformations(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("vlaubhwvllxlkrjc")
    public suspend fun textTransformations(vararg values: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementArgs(
            fieldToMatch = fieldToMatch,
            sensitivityLevel = sensitivityLevel,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
