@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headerOrders Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class
WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs(
    public val allQueryArguments: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null,
    public val body: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgs>? =
        null,
    public val cookies: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgs>? =
        null,
    public val headerOrders: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>? =
        null,
    public val headers: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null,
    public val ja3Fingerprint: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null,
    public val jsonBody: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null,
    public val method: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgs>? =
        null,
    public val queryString: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgs>? =
        null,
    public val singleHeader: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? =
        null,
    public val singleQueryArgument: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null,
    public val uriPath: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs.builder()
            .allQueryArguments(allQueryArguments?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .body(body?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .cookies(cookies?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .headerOrders(
                headerOrders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ja3Fingerprint(ja3Fingerprint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jsonBody(jsonBody?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .method(method?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queryString(queryString?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleHeader(singleHeader?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .singleQueryArgument(
                singleQueryArgument?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .uriPath(uriPath?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgsBuilder
internal constructor() {
    private var allQueryArguments:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>? =
        null

    private var body:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgs>? =
        null

    private var cookies:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgs>? =
        null

    private var headerOrders:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>? =
        null

    private var headers:
        Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>>? =
        null

    private var ja3Fingerprint:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>? =
        null

    private var jsonBody:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgs>? =
        null

    private var method:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgs>? =
        null

    private var queryString:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgs>? =
        null

    private var singleHeader:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>? =
        null

    private var singleQueryArgument:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>? =
        null

    private var uriPath:
        Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgs>? =
        null

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ptmjgfwcqjxdgsuv")
    public suspend fun allQueryArguments(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs>) {
        this.allQueryArguments = value
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("yxmlpbprkkfwuidi")
    public suspend fun body(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgs>) {
        this.body = value
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("qutgklrcyniwdhfb")
    public suspend fun cookies(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgs>) {
        this.cookies = value
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("dbmceoyysaioqmvs")
    public suspend fun headerOrders(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = value
    }

    @JvmName("msrgpijaofeypfkj")
    public suspend fun headerOrders(vararg values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>) {
        this.headerOrders = Output.all(values.asList())
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("pfuwdvoqfjchjgkx")
    public suspend fun headerOrders(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>>) {
        this.headerOrders = Output.all(values)
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("meodwrcfsxspkbra")
    public suspend fun headers(`value`: Output<List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = value
    }

    @JvmName("ocnvdwxoovnaefly")
    public suspend fun headers(vararg values: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>) {
        this.headers = Output.all(values.asList())
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("mjpuysjcybgsosxw")
    public suspend fun headers(values: List<Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>>) {
        this.headers = Output.all(values)
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("omdwuhykphrjsqud")
    public suspend fun ja3Fingerprint(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs>) {
        this.ja3Fingerprint = value
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("yltdhlmrurvkbyal")
    public suspend fun jsonBody(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgs>) {
        this.jsonBody = value
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("jltukvqxrdfpuiaj")
    public suspend fun method(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgs>) {
        this.method = value
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("dxxobtretqqqjyih")
    public suspend fun queryString(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgs>) {
        this.queryString = value
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("yxcuotflujetalhu")
    public suspend fun singleHeader(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgs>) {
        this.singleHeader = value
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("oivscwtnkkfwlyul")
    public suspend fun singleQueryArgument(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs>) {
        this.singleQueryArgument = value
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("icukrvxeknbtumsh")
    public suspend fun uriPath(`value`: Output<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgs>) {
        this.uriPath = value
    }

    /**
     * @param value Inspect all query arguments.
     */
    @JvmName("ugojnkjcboodvfba")
    public suspend fun allQueryArguments(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allQueryArguments = mapped
    }

    /**
     * @param argument Inspect all query arguments.
     */
    @JvmName("bhsjtrwjoxtylbjd")
    public suspend fun allQueryArguments(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchAllQueryArgumentsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.allQueryArguments = mapped
    }

    /**
     * @param value Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("mndpgkbsevihaqjo")
    public suspend fun body(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param argument Inspect the request body, which immediately follows the request headers. See `body` below for details.
     */
    @JvmName("yxxtoptqmddvsrje")
    public suspend fun body(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.body = mapped
    }

    /**
     * @param value Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("ttxpbfehqfnpnvgg")
    public suspend fun cookies(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cookies = mapped
    }

    /**
     * @param argument Inspect the cookies in the web request. See `cookies` below for details.
     */
    @JvmName("lrsdqgeoaqhmmlgt")
    public suspend fun cookies(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchCookiesArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.cookies = mapped
    }

    /**
     * @param value Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("iiueleohkarjjenb")
    public suspend fun headerOrders(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("wrfkttcdlcftypef")
    public suspend fun headerOrders(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("kcwfhnncpqvfposo")
    public suspend fun headerOrders(vararg argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param argument Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("oojubecxclkdrkpc")
    public suspend fun headerOrders(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headerOrders = mapped
    }

    /**
     * @param values Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
     */
    @JvmName("nrqkmjckibrmsicg")
    public suspend fun headerOrders(vararg values: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderOrderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headerOrders = mapped
    }

    /**
     * @param value Inspect the request headers. See `headers` below for details.
     */
    @JvmName("fwueojtrlucipxwd")
    public suspend fun headers(`value`: List<WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("jvjaukvatvacolju")
    public suspend fun headers(argument: List<suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vlhjeocinpoioxrr")
    public suspend fun headers(vararg argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param argument Inspect the request headers. See `headers` below for details.
     */
    @JvmName("vjwkbwaedggoalmj")
    public suspend fun headers(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.headers = mapped
    }

    /**
     * @param values Inspect the request headers. See `headers` below for details.
     */
    @JvmName("ldohhyjqstaxdmws")
    public suspend fun headers(vararg values: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param value Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("arqclyniddikoqgb")
    public suspend fun ja3Fingerprint(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ja3Fingerprint = mapped
    }

    /**
     * @param argument Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
     */
    @JvmName("mhcmsqkliqaxwtrr")
    public suspend fun ja3Fingerprint(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJa3FingerprintArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ja3Fingerprint = mapped
    }

    /**
     * @param value Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("ryluthjejbdvorpl")
    public suspend fun jsonBody(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonBody = mapped
    }

    /**
     * @param argument Inspect the request body as JSON. See `json_body` for details.
     */
    @JvmName("jbvexkqtetowgjri")
    public suspend fun jsonBody(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchJsonBodyArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.jsonBody = mapped
    }

    /**
     * @param value Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("mtwdwyutxobrojtg")
    public suspend fun method(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param argument Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
     */
    @JvmName("iektrusctudtotit")
    public suspend fun method(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchMethodArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.method = mapped
    }

    /**
     * @param value Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("ikledlqfjvpygieh")
    public suspend fun queryString(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryString = mapped
    }

    /**
     * @param argument Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
     */
    @JvmName("hgricvycmljtdegb")
    public suspend fun queryString(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchQueryStringArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.queryString = mapped
    }

    /**
     * @param value Inspect a single header. See `single_header` below for details.
     */
    @JvmName("trexssgelpxxecrb")
    public suspend fun singleHeader(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleHeader = mapped
    }

    /**
     * @param argument Inspect a single header. See `single_header` below for details.
     */
    @JvmName("kghjpdtobiupsxvp")
    public suspend fun singleHeader(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleHeaderArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleHeader = mapped
    }

    /**
     * @param value Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("dqxuhqumddwoatti")
    public suspend fun singleQueryArgument(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.singleQueryArgument = mapped
    }

    /**
     * @param argument Inspect a single query argument. See `single_query_argument` below for details.
     */
    @JvmName("yjwffxcvehtmxqxx")
    public suspend fun singleQueryArgument(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchSingleQueryArgumentArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.singleQueryArgument = mapped
    }

    /**
     * @param value Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("msnpnqvlibmiggdi")
    public suspend fun uriPath(`value`: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uriPath = mapped
    }

    /**
     * @param argument Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
     */
    @JvmName("fnuwfywflmqhpdbg")
    public suspend fun uriPath(argument: suspend WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchUriPathArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.uriPath = mapped
    }

    internal fun build(): WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs =
        WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatchArgs(
            allQueryArguments = allQueryArguments,
            body = body,
            cookies = cookies,
            headerOrders = headerOrders,
            headers = headers,
            ja3Fingerprint = ja3Fingerprint,
            jsonBody = jsonBody,
            method = method,
            queryString = queryString,
            singleHeader = singleHeader,
            singleQueryArgument = singleQueryArgument,
            uriPath = uriPath,
        )
}
