@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
 * @property fieldToMatch Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
 */
public data class WebAclRuleStatementRegexPatternSetReferenceStatementArgs(
    public val arn: Output<String>,
    public val fieldToMatch: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? = null,
    public val textTransformations: Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRegexPatternSetReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .fieldToMatch(fieldToMatch?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .textTransformations(
                textTransformations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRegexPatternSetReferenceStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRegexPatternSetReferenceStatementArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var fieldToMatch:
        Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>? = null

    private var textTransformations:
        Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("etihwpnpibgkrhvu")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("bcuhylymojqclegl")
    public suspend fun fieldToMatch(`value`: Output<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs>) {
        this.fieldToMatch = value
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("ouchavkqjhpywfgv")
    public suspend fun textTransformations(`value`: Output<List<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = value
    }

    @JvmName("xcjjitjcxsrfbrcl")
    public suspend fun textTransformations(vararg values: Output<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>) {
        this.textTransformations = Output.all(values.asList())
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("xorywieaogurybex")
    public suspend fun textTransformations(values: List<Output<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>>) {
        this.textTransformations = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Regex Pattern Set that this statement references.
     */
    @JvmName("tfsfxqcurkmyuyyk")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("misuewwcpgstkcas")
    public suspend fun fieldToMatch(`value`: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fieldToMatch = mapped
    }

    /**
     * @param argument Part of a web request that you want AWS WAF to inspect. See `field_to_match` below for details.
     */
    @JvmName("wuoacnppdwixttop")
    public suspend fun fieldToMatch(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.fieldToMatch = mapped
    }

    /**
     * @param value Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("cqvpdkwrsewjatpi")
    public suspend fun textTransformations(`value`: List<WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("wamjjgcgrahhxfqy")
    public suspend fun textTransformations(argument: List<suspend WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("htetgbyykvalsrlg")
    public suspend fun textTransformations(vararg argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param argument Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("abgoutjqiuaenhhf")
    public suspend fun textTransformations(argument: suspend WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.textTransformations = mapped
    }

    /**
     * @param values Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. At least one transformation is required. See `text_transformation` below for details.
     */
    @JvmName("wbjllenlgqtjjxxp")
    public suspend fun textTransformations(vararg values: WebAclRuleStatementRegexPatternSetReferenceStatementTextTransformationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.textTransformations = mapped
    }

    internal fun build(): WebAclRuleStatementRegexPatternSetReferenceStatementArgs =
        WebAclRuleStatementRegexPatternSetReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            fieldToMatch = fieldToMatch,
            textTransformations = textTransformations ?: throw PulumiNullFieldException("textTransformations"),
        )
}
