@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the `aws.wafv2.RuleGroup` resource.
 * @property ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
 */
public data class WebAclRuleStatementRuleGroupReferenceStatementArgs(
    public val arn: Output<String>,
    public val ruleActionOverrides: Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .ruleActionOverrides(
                ruleActionOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRuleGroupReferenceStatementArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRuleGroupReferenceStatementArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var ruleActionOverrides:
        Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the `aws.wafv2.RuleGroup` resource.
     */
    @JvmName("qkekktpqyjujagui")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("iwnuhrjjdmdnjgbc")
    public suspend fun ruleActionOverrides(`value`: Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>>) {
        this.ruleActionOverrides = value
    }

    @JvmName("odhvllcqnclmhkfr")
    public suspend fun ruleActionOverrides(vararg values: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>) {
        this.ruleActionOverrides = Output.all(values.asList())
    }

    /**
     * @param values Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("lolngtkrtmngjgfl")
    public suspend fun ruleActionOverrides(values: List<Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>>) {
        this.ruleActionOverrides = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the `aws.wafv2.RuleGroup` resource.
     */
    @JvmName("aiakacyhfxtttrxc")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("ucryfucupemwxkxu")
    public suspend fun ruleActionOverrides(`value`: List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("cbfrsilhyeqxqkhh")
    public suspend fun ruleActionOverrides(argument: List<suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("nphdkfvebsvhqsih")
    public suspend fun ruleActionOverrides(vararg argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param argument Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("ipcodnclcmqayysc")
    public suspend fun ruleActionOverrides(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.ruleActionOverrides = mapped
    }

    /**
     * @param values Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
     */
    @JvmName("wxkdvshcporetlaq")
    public suspend fun ruleActionOverrides(vararg values: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleActionOverrides = mapped
    }

    internal fun build(): WebAclRuleStatementRuleGroupReferenceStatementArgs =
        WebAclRuleStatementRuleGroupReferenceStatementArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            ruleActionOverrides = ruleActionOverrides,
        )
}
