@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property customResponseBodyKey References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
 * @property responseCode The HTTP status code to return to the client.
 * @property responseHeaders The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
 */
public data class
WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs(
    public val customResponseBodyKey: Output<String>? = null,
    public val responseCode: Output<Int>,
    public val responseHeaders: Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs.builder()
            .customResponseBodyKey(customResponseBodyKey?.applyValue({ args0 -> args0 }))
            .responseCode(responseCode.applyValue({ args0 -> args0 }))
            .responseHeaders(
                responseHeaders?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs].
 */
@PulumiTagMarker
public class
WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgsBuilder
internal constructor() {
    private var customResponseBodyKey: Output<String>? = null

    private var responseCode: Output<Int>? = null

    private var responseHeaders:
        Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>? =
        null

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("lfdvlutcejhiutei")
    public suspend fun customResponseBodyKey(`value`: Output<String>) {
        this.customResponseBodyKey = value
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("ebyruatmgqbaxdpk")
    public suspend fun responseCode(`value`: Output<Int>) {
        this.responseCode = value
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("ustgpvnihbbeijwv")
    public suspend fun responseHeaders(`value`: Output<List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = value
    }

    @JvmName("voewxxrtmviuupjk")
    public suspend fun responseHeaders(vararg values: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>) {
        this.responseHeaders = Output.all(values.asList())
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("qgecqaqjdohmrfuh")
    public suspend fun responseHeaders(values: List<Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>>) {
        this.responseHeaders = Output.all(values)
    }

    /**
     * @param value References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
     */
    @JvmName("nhotfrwkuocqfjbe")
    public suspend fun customResponseBodyKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customResponseBodyKey = mapped
    }

    /**
     * @param value The HTTP status code to return to the client.
     */
    @JvmName("sagpbxkfqsuotmxd")
    public suspend fun responseCode(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseCode = mapped
    }

    /**
     * @param value The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("kovfjtsnqadmfevy")
    public suspend fun responseHeaders(`value`: List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("paxeutjfsboqapdu")
    public suspend fun responseHeaders(argument: List<suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("iycuwlkpukymqeku")
    public suspend fun responseHeaders(vararg argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param argument The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("vhdprebcqimrccrc")
    public suspend fun responseHeaders(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.responseHeaders = mapped
    }

    /**
     * @param values The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
     */
    @JvmName("wlucabeegbqdtaky")
    public suspend fun responseHeaders(vararg values: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeaderArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.responseHeaders = mapped
    }

    internal fun build(): WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs =
        WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseArgs(
            customResponseBodyKey = customResponseBodyKey,
            responseCode = responseCode ?: throw PulumiNullFieldException("responseCode"),
            responseHeaders = responseHeaders,
        )
}
