@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.inputs

import com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property actionToUse Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
 * @property name Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
 */
public data class WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs(
    public val actionToUse: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs>,
    public val name: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs> {
    override fun toJava(): com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs =
        com.pulumi.aws.wafv2.inputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs.builder()
            .actionToUse(actionToUse.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs].
 */
@PulumiTagMarker
public class WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgsBuilder internal constructor() {
    private var actionToUse:
        Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs>? =
        null

    private var name: Output<String>? = null

    /**
     * @param value Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("dxkvhfoapnimokah")
    public suspend fun actionToUse(`value`: Output<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs>) {
        this.actionToUse = value
    }

    /**
     * @param value Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
     */
    @JvmName("espjnbnqkvshgyou")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("fqhqemiorlrypbli")
    public suspend fun actionToUse(`value`: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actionToUse = mapped
    }

    /**
     * @param argument Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
     */
    @JvmName("lnlxpfaodblggkyr")
    public suspend fun actionToUse(argument: suspend WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgsBuilder.() -> Unit) {
        val toBeMapped =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.actionToUse = mapped
    }

    /**
     * @param value Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
     */
    @JvmName("sutamibqewellohv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs =
        WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideArgs(
            actionToUse = actionToUse ?: throw PulumiNullFieldException("actionToUse"),
            name = name ?: throw PulumiNullFieldException("name"),
        )
}
