@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property action The action that AWS WAF should take on a web request when it matches the rule's statement. Settings at the `aws.wafv2.WebAcl` level can override the rule action setting. See Action below for details.
 * @property captchaConfig Specifies how AWS WAF should handle CAPTCHA evaluations. See Captcha Configuration below for details.
 * @property name A friendly name of the rule.
 * @property priority If you define more than one Rule in a WebACL, AWS WAF evaluates each request against the `rules` in order based on the value of `priority`. AWS WAF processes rules with lower priority first.
 * @property ruleLabels Labels to apply to web requests that match the rule match statement. See Rule Label below for details.
 * @property statement The AWS WAF processing statement for the rule, for example `byte_match_statement` or `geo_match_statement`. See Statement below for details.
 * @property visibilityConfig Defines and enables Amazon CloudWatch metrics and web request sample collection. See Visibility Configuration below for details.
 */
public data class RuleGroupRule(
    public val action: RuleGroupRuleAction,
    public val captchaConfig: RuleGroupRuleCaptchaConfig? = null,
    public val name: String,
    public val priority: Int,
    public val ruleLabels: List<RuleGroupRuleRuleLabel>? = null,
    public val statement: RuleGroupRuleStatement,
    public val visibilityConfig: RuleGroupRuleVisibilityConfig,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRule): RuleGroupRule =
            RuleGroupRule(
                action = javaType.action().let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleAction.Companion.toKotlin(args0)
                }),
                captchaConfig = javaType.captchaConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleCaptchaConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                name = javaType.name(),
                priority = javaType.priority(),
                ruleLabels = javaType.ruleLabels().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleRuleLabel.Companion.toKotlin(args0)
                    })
                }),
                statement = javaType.statement().let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatement.Companion.toKotlin(args0)
                }),
                visibilityConfig = javaType.visibilityConfig().let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleVisibilityConfig.Companion.toKotlin(args0)
                }),
            )
    }
}
