@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See Allow below for details.
 * @property block Instructs AWS WAF to block the web request. See Block below for details.
 * @property captcha Instructs AWS WAF to run a `CAPTCHA` check against the web request. See Captcha below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See Challenge below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See Count below for details.
 */
public data class RuleGroupRuleAction(
    public val allow: RuleGroupRuleActionAllow? = null,
    public val block: RuleGroupRuleActionBlock? = null,
    public val captcha: RuleGroupRuleActionCaptcha? = null,
    public val challenge: RuleGroupRuleActionChallenge? = null,
    public val count: RuleGroupRuleActionCount? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleAction): RuleGroupRuleAction = RuleGroupRuleAction(
            allow = javaType.allow().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleActionAllow.Companion.toKotlin(args0)
                })
            }).orElse(null),
            block = javaType.block().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleActionBlock.Companion.toKotlin(args0)
                })
            }).orElse(null),
            captcha = javaType.captcha().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleActionCaptcha.Companion.toKotlin(args0)
                })
            }).orElse(null),
            challenge = javaType.challenge().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleActionChallenge.Companion.toKotlin(args0)
                })
            }).orElse(null),
            count = javaType.count().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleActionCount.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
