@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See Text Transformation above for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath(
    public val textTransformations: List<RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath): RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath =
            RuleGroupRuleStatementRateBasedStatementCustomKeyUriPath(
                textTransformations = javaType.textTransformations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementCustomKeyUriPathTextTransformation.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
