@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property positionalConstraint The area within the portion of a web request that you want AWS WAF to search for `search_string`. Valid values include the following: `EXACTLY`, `STARTS_WITH`, `ENDS_WITH`, `CONTAINS`, `CONTAINS_WORD`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/APIReference/API_ByteMatchStatement.html) for more information.
 * @property searchString A string value that you want AWS WAF to search for. AWS WAF searches only in the part of web requests that you designate for inspection in `field_to_match`. The maximum length of the value is 50 bytes.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement(
    public val fieldToMatch: RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatch? =
        null,
    public val positionalConstraint: String,
    public val searchString: String,
    public val textTransformations: List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement): RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement(
                fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementFieldToMatch.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                positionalConstraint = javaType.positionalConstraint(),
                searchString = javaType.searchString(),
                textTransformations = javaType.textTransformations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementByteMatchStatementTextTransformation.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
