@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property sensitivityLevel Sensitivity that you want AWS WAF to use to inspect for SQL injection attacks. Valid values include: `LOW`, `HIGH`.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement(
    public val fieldToMatch: RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatch? =
        null,
    public val sensitivityLevel: String? = null,
    public val textTransformations: List<RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement): RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement =
            RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement(
                fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementFieldToMatch.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sensitivityLevel = javaType.sensitivityLevel().map({ args0 -> args0 }).orElse(null),
                textTransformations = javaType.textTransformations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatementTextTransformation.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
