@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property fieldToMatch The part of a web request that you want AWS WAF to inspect. See Field to Match below for details.
 * @property regexString The string representing the regular expression. **Note:** The fixed quota for the maximum number of characters in each regex pattern is 200, which can't be changed. See [AWS WAF quotas](https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) for details.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection.
 * At least one required.
 * See Text Transformation below for details.
 */
public data class RuleGroupRuleStatementRegexMatchStatement(
    public val fieldToMatch: RuleGroupRuleStatementRegexMatchStatementFieldToMatch? = null,
    public val regexString: String,
    public val textTransformations: List<RuleGroupRuleStatementRegexMatchStatementTextTransformation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementRegexMatchStatement): RuleGroupRuleStatementRegexMatchStatement = RuleGroupRuleStatementRegexMatchStatement(
            fieldToMatch = javaType.fieldToMatch().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexMatchStatementFieldToMatch.Companion.toKotlin(args0)
                })
            }).orElse(null),
            regexString = javaType.regexString(),
            textTransformations = javaType.textTransformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementRegexMatchStatementTextTransformation.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
