@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers.
 * @property cookies Inspect the cookies in the web request. See Cookies below for details.
 * @property headerOrders Inspect the request headers. See Header Order below for details.
 * @property headers Inspect the request headers. See Headers below for details.
 * @property ja3Fingerprint
 * @property jsonBody Inspect the request body as JSON. See JSON Body for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See Single Header below for details.
 * @property singleQueryArgument Inspect a single query argument. See Single Query Argument below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class RuleGroupRuleStatementSqliMatchStatementFieldToMatch(
    public val allQueryArguments: RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArguments? = null,
    public val body: RuleGroupRuleStatementSqliMatchStatementFieldToMatchBody? = null,
    public val cookies: RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookies? = null,
    public val headerOrders: List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder>? =
        null,
    public val headers: List<RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeader>? = null,
    public val ja3Fingerprint: RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3Fingerprint? =
        null,
    public val jsonBody: RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBody? = null,
    public val method: RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethod? = null,
    public val queryString: RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryString? = null,
    public val singleHeader: RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeader? = null,
    public val singleQueryArgument: RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgument? = null,
    public val uriPath: RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPath? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatch): RuleGroupRuleStatementSqliMatchStatementFieldToMatch =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headerOrders = javaType.headerOrders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder.Companion.toKotlin(args0)
                    })
                }),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
