@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property oversizeHandling Oversize handling tells AWS WAF what to do with a web request when the request component that the rule inspects is over the limits. Valid values include the following: `CONTINUE`, `MATCH`, `NO_MATCH`. See the AWS [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/waf-rule-statement-oversize-handling.html) for more information.
 */
public data class RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder(
    public val oversizeHandling: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder): RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder =
            RuleGroupRuleStatementSqliMatchStatementFieldToMatchHeaderOrder(
                oversizeHandling = javaType.oversizeHandling(),
            )
    }
}
