@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchMetricsEnabled A boolean indicating whether the associated resource sends metrics to CloudWatch. For the list of available metrics, see [AWS WAF Metrics](https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
 * @property metricName A friendly name of the CloudWatch metric. The name can contain only alphanumeric characters (A-Z, a-z, 0-9) hyphen(-) and underscore (_), with length from one to 128 characters. It can't contain whitespace or metric names reserved for AWS WAF, for example `All` and `Default_Action`.
 * @property sampledRequestsEnabled A boolean indicating whether AWS WAF should store a sampling of the web requests that match the rules. You can view the sampled requests through the AWS WAF console.
 */
public data class RuleGroupVisibilityConfig(
    public val cloudwatchMetricsEnabled: Boolean,
    public val metricName: String,
    public val sampledRequestsEnabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.RuleGroupVisibilityConfig): RuleGroupVisibilityConfig = RuleGroupVisibilityConfig(
            cloudwatchMetricsEnabled = javaType.cloudwatchMetricsEnabled(),
            metricName = javaType.metricName(),
            sampledRequestsEnabled = javaType.sampledRequestsEnabled(),
        )
    }
}
