@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property apiGateways Customizes the request body that your protected Amazon API Gateway REST APIs forward to AWS WAF for inspection. Applicable only when `scope` is set to `CLOUDFRONT`. See `api_gateway` below for details.
 * @property appRunnerServices Customizes the request body that your protected Amazon App Runner services forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `app_runner_service` below for details.
 * @property cloudfronts Customizes the request body that your protected Amazon CloudFront distributions forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cloudfront` below for details.
 * @property cognitoUserPools Customizes the request body that your protected Amazon Cognito user pools forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `cognito_user_pool` below for details.
 * @property verifiedAccessInstances Customizes the request body that your protected AWS Verfied Access instances forward to AWS WAF for inspection. Applicable only when `scope` is set to `REGIONAL`. See `verified_access_instance` below for details.
 */
public data class WebAclAssociationConfigRequestBody(
    public val apiGateways: List<WebAclAssociationConfigRequestBodyApiGateway>? = null,
    public val appRunnerServices: List<WebAclAssociationConfigRequestBodyAppRunnerService>? = null,
    public val cloudfronts: List<WebAclAssociationConfigRequestBodyCloudfront>? = null,
    public val cognitoUserPools: List<WebAclAssociationConfigRequestBodyCognitoUserPool>? = null,
    public val verifiedAccessInstances: List<WebAclAssociationConfigRequestBodyVerifiedAccessInstance>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclAssociationConfigRequestBody): WebAclAssociationConfigRequestBody = WebAclAssociationConfigRequestBody(
            apiGateways = javaType.apiGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfigRequestBodyApiGateway.Companion.toKotlin(args0)
                })
            }),
            appRunnerServices = javaType.appRunnerServices().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfigRequestBodyAppRunnerService.Companion.toKotlin(args0)
                })
            }),
            cloudfronts = javaType.cloudfronts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfigRequestBodyCloudfront.Companion.toKotlin(args0)
                })
            }),
            cognitoUserPools = javaType.cognitoUserPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfigRequestBodyCognitoUserPool.Companion.toKotlin(args0)
                })
            }),
            verifiedAccessInstances = javaType.verifiedAccessInstances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclAssociationConfigRequestBodyVerifiedAccessInstance.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
