@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property defaultSizeInspectionLimit Specifies the maximum size of the web request body component that an associated Amazon API Gateway REST APIs should send to AWS WAF for inspection. This applies to statements in the web ACL that inspect the body or JSON body. Valid values are `KB_16`, `KB_32`, `KB_48` and `KB_64`.
 */
public data class WebAclAssociationConfigRequestBodyApiGateway(
    public val defaultSizeInspectionLimit: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclAssociationConfigRequestBodyApiGateway): WebAclAssociationConfigRequestBodyApiGateway = WebAclAssociationConfigRequestBodyApiGateway(
            defaultSizeInspectionLimit = javaType.defaultSizeInspectionLimit(),
        )
    }
}
