@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property behavior Parameter that determines how to handle logs that meet the conditions and requirements of the filter. The valid values for `behavior` are `KEEP` or `DROP`.
 * @property conditions Match condition(s) for the filter. See Condition below for more details.
 * @property requirement Logic to apply to the filtering conditions. You can specify that a log must match all conditions or at least one condition in order to satisfy the filter. Valid values for `requirement` are `MEETS_ALL` or `MEETS_ANY`.
 */
public data class WebAclLoggingConfigurationLoggingFilterFilter(
    public val behavior: String,
    public val conditions: List<WebAclLoggingConfigurationLoggingFilterFilterCondition>,
    public val requirement: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclLoggingConfigurationLoggingFilterFilter): WebAclLoggingConfigurationLoggingFilterFilter =
            WebAclLoggingConfigurationLoggingFilterFilter(
                behavior = javaType.behavior(),
                conditions = javaType.conditions().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationLoggingFilterFilterCondition.Companion.toKotlin(args0)
                    })
                }),
                requirement = javaType.requirement(),
            )
    }
}
