@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property method HTTP method to be redacted. It must be specified as an empty configuration block `{}`. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Whether to redact the query string. It must be specified as an empty configuration block `{}`. The query string is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader "single_header" refers to the redaction of a single header. For more information, please see the details below under Single Header.
 * @property uriPath Configuration block that redacts the request URI path. It should be specified as an empty configuration block `{}`. The URI path is the part of a web request that identifies a resource, such as `/images/daily-ad.jpg`.
 */
public data class WebAclLoggingConfigurationRedactedField(
    public val method: WebAclLoggingConfigurationRedactedFieldMethod? = null,
    public val queryString: WebAclLoggingConfigurationRedactedFieldQueryString? = null,
    public val singleHeader: WebAclLoggingConfigurationRedactedFieldSingleHeader? = null,
    public val uriPath: WebAclLoggingConfigurationRedactedFieldUriPath? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclLoggingConfigurationRedactedField): WebAclLoggingConfigurationRedactedField = WebAclLoggingConfigurationRedactedField(
            method = javaType.method().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedFieldMethod.Companion.toKotlin(args0)
                })
            }).orElse(null),
            queryString = javaType.queryString().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedFieldQueryString.Companion.toKotlin(args0)
                })
            }).orElse(null),
            singleHeader = javaType.singleHeader().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedFieldSingleHeader.Companion.toKotlin(args0)
                })
            }).orElse(null),
            uriPath = javaType.uriPath().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclLoggingConfigurationRedactedFieldUriPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
