@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property allow Instructs AWS WAF to allow the web request. See `allow` below for details.
 * @property block Instructs AWS WAF to block the web request. See `block` below for details.
 * @property captcha Instructs AWS WAF to run a Captcha check against the web request. See `captcha` below for details.
 * @property challenge Instructs AWS WAF to run a check against the request to verify that the request is coming from a legitimate client session. See `challenge` below for details.
 * @property count Instructs AWS WAF to count the web request and allow it. See `count` below for details.
 */
public data class WebAclRuleAction(
    public val allow: WebAclRuleActionAllow? = null,
    public val block: WebAclRuleActionBlock? = null,
    public val captcha: WebAclRuleActionCaptcha? = null,
    public val challenge: WebAclRuleActionChallenge? = null,
    public val count: WebAclRuleActionCount? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleAction): WebAclRuleAction =
            WebAclRuleAction(
                allow = javaType.allow().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleActionAllow.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                block = javaType.block().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleActionBlock.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                captcha = javaType.captcha().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleActionCaptcha.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                challenge = javaType.challenge().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleActionChallenge.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                count = javaType.count().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleActionCount.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
