@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property awsManagedRulesAcfpRuleSet Additional configuration for using the Account Creation Fraud Prevention managed rule group. Use this to specify information such as the registration page of your application and the type of content to accept or reject from the client.
 * @property awsManagedRulesAtpRuleSet Additional configuration for using the Account Takeover Protection managed rule group. Use this to specify information such as the sign-in page of your application and the type of content to accept or reject from the client.
 * @property awsManagedRulesBotControlRuleSet Additional configuration for using the Bot Control managed rule group. Use this to specify the inspection level that you want to use. See `aws_managed_rules_bot_control_rule_set` for more details
 * @property loginPath The path of the login endpoint for your application.
 * @property passwordField Details about your login page password field. See `password_field` for more details.
 * @property payloadType The payload type for your login endpoint, either JSON or form encoded.
 * @property usernameField Details about your login page username field. See `username_field` for more details.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig(
    public val awsManagedRulesAcfpRuleSet: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet? =
        null,
    public val awsManagedRulesAtpRuleSet: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet? =
        null,
    public val awsManagedRulesBotControlRuleSet: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSet? =
        null,
    public val loginPath: String? = null,
    public val passwordField: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordField? = null,
    public val payloadType: String? = null,
    public val usernameField: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameField? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfig(
                awsManagedRulesAcfpRuleSet = javaType.awsManagedRulesAcfpRuleSet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                awsManagedRulesAtpRuleSet = javaType.awsManagedRulesAtpRuleSet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAtpRuleSet.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                awsManagedRulesBotControlRuleSet = javaType.awsManagedRulesBotControlRuleSet().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesBotControlRuleSet.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                loginPath = javaType.loginPath().map({ args0 -> args0 }).orElse(null),
                passwordField = javaType.passwordField().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigPasswordField.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                payloadType = javaType.payloadType().map({ args0 -> args0 }).orElse(null),
                usernameField = javaType.usernameField().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigUsernameField.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
