@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationPath The path of the account creation endpoint for your application. This is the page on your website that accepts the completed registration form for a new user. This page must accept POST requests.
 * @property enableRegexInPath Whether or not to allow the use of regular expressions in the login page path.
 * @property registrationPagePath The path of the account registration endpoint for your application. This is the page on your website that presents the registration form to new users. This page must accept GET text/html requests.
 * @property requestInspection The criteria for inspecting login requests, used by the ATP rule group to validate credentials usage. See `request_inspection` for more details.
 * @property responseInspection The criteria for inspecting responses to login requests, used by the ATP rule group to track login failure rates. Note that Response Inspection is available only on web ACLs that protect CloudFront distributions. See `response_inspection` for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet(
    public val creationPath: String,
    public val enableRegexInPath: Boolean? = null,
    public val registrationPagePath: String,
    public val requestInspection: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspection,
    public val responseInspection: WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspection? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet): WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet =
            WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSet(
                creationPath = javaType.creationPath(),
                enableRegexInPath = javaType.enableRegexInPath().map({ args0 -> args0 }).orElse(null),
                registrationPagePath = javaType.registrationPagePath(),
                requestInspection = javaType.requestInspection().let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetRequestInspection.Companion.toKotlin(args0)
                }),
                responseInspection = javaType.responseInspection().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementManagedRuleGroupConfigAwsManagedRulesAcfpRuleSetResponseInspection.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
