@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement(
    public val andStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatement? = null,
    public val byteMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatement? = null,
    public val geoMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatement? = null,
    public val ipSetReferenceStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement? = null,
    public val labelMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatement? = null,
    public val notStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatement? = null,
    public val orStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatement? =
        null,
    public val regexMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatement? = null,
    public val regexPatternSetReferenceStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatement? =
        null,
    public val sizeConstraintStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatement? = null,
    public val sqliMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatement? = null,
    public val xssMatchStatement: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatement? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatement(
                andStatement = javaType.andStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementAndStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                byteMatchStatement = javaType.byteMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementByteMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                geoMatchStatement = javaType.geoMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementGeoMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ipSetReferenceStatement = javaType.ipSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                labelMatchStatement = javaType.labelMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementLabelMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                notStatement = javaType.notStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementNotStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                orStatement = javaType.orStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementOrStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexMatchStatement = javaType.regexMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexPatternSetReferenceStatement = javaType.regexPatternSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementRegexPatternSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sizeConstraintStatement = javaType.sizeConstraintStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSizeConstraintStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqliMatchStatement = javaType.sqliMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementSqliMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                xssMatchStatement = javaType.xssMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementXssMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
