@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the IP Set that this statement references.
 * @property ipSetForwardedIpConfig Configuration for inspecting IP addresses in an HTTP header that you specify, instead of using the IP address that's reported by the web request origin. See `ip_set_forwarded_ip_config` below for more details.
 */
public data class
WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement(
    public val arn: String,
    public val ipSetForwardedIpConfig: WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfig? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement): WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement =
            WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatement(
                arn = javaType.arn(),
                ipSetForwardedIpConfig = javaType.ipSetForwardedIpConfig().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementManagedRuleGroupStatementScopeDownStatementIpSetReferenceStatementIpSetForwardedIpConfig.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
