@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property cookie Use the value of a cookie in the request as an aggregate key. See RateLimit `cookie` below for details.
 * @property forwardedIp Use the first IP address in an HTTP header as an aggregate key. See `forwarded_ip` below for details.
 * @property header Use the value of a header in the request as an aggregate key. See RateLimit `header` below for details.
 * @property httpMethod Use the request's HTTP method as an aggregate key. See RateLimit `http_method` below for details.
 * @property ip Use the request's originating IP address as an aggregate key. See `RateLimit ip` below for details.
 * @property labelNamespace Use the specified label namespace as an aggregate key. See RateLimit `label_namespace` below for details.
 * @property queryArgument Use the specified query argument as an aggregate key. See RateLimit `query_argument` below for details.
 * @property queryString Use the request's query string as an aggregate key. See RateLimit `query_string` below for details.
 * @property uriPath Use the request's URI path as an aggregate key. See RateLimit `uri_path` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKey(
    public val cookie: WebAclRuleStatementRateBasedStatementCustomKeyCookie? = null,
    public val forwardedIp: WebAclRuleStatementRateBasedStatementCustomKeyForwardedIp? = null,
    public val `header`: WebAclRuleStatementRateBasedStatementCustomKeyHeader? = null,
    public val httpMethod: WebAclRuleStatementRateBasedStatementCustomKeyHttpMethod? = null,
    public val ip: WebAclRuleStatementRateBasedStatementCustomKeyIp? = null,
    public val labelNamespace: WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespace? = null,
    public val queryArgument: WebAclRuleStatementRateBasedStatementCustomKeyQueryArgument? = null,
    public val queryString: WebAclRuleStatementRateBasedStatementCustomKeyQueryString? = null,
    public val uriPath: WebAclRuleStatementRateBasedStatementCustomKeyUriPath? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRateBasedStatementCustomKey): WebAclRuleStatementRateBasedStatementCustomKey =
            WebAclRuleStatementRateBasedStatementCustomKey(
                cookie = javaType.cookie().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyCookie.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                forwardedIp = javaType.forwardedIp().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyForwardedIp.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                `header` = javaType.`header`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                httpMethod = javaType.httpMethod().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyHttpMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ip = javaType.ip().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyIp.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                labelNamespace = javaType.labelNamespace().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyLabelNamespace.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryArgument = javaType.queryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
