@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property name The name of the header to use.
 * @property textTransformations Text transformations eliminate some of the unusual formatting that attackers use in web requests in an effort to bypass detection. They are used in rate-based rule statements, to transform request components before using them as custom aggregation keys. Atleast one transformation is required. See `text_transformation` above for details.
 */
public data class WebAclRuleStatementRateBasedStatementCustomKeyHeader(
    public val name: String,
    public val textTransformations: List<WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformation>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRateBasedStatementCustomKeyHeader): WebAclRuleStatementRateBasedStatementCustomKeyHeader =
            WebAclRuleStatementRateBasedStatementCustomKeyHeader(
                name = javaType.name(),
                textTransformations = javaType.textTransformations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementCustomKeyHeaderTextTransformation.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
