@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property andStatement Logical rule statement used to combine other rule statements with AND logic. See `and_statement` below for details.
 * @property byteMatchStatement Rule statement that defines a string match search for AWS WAF to apply to web requests. See `byte_match_statement` below for details.
 * @property geoMatchStatement Rule statement used to identify web requests based on country of origin. See `geo_match_statement` below for details.
 * @property ipSetReferenceStatement Rule statement used to detect web requests coming from particular IP addresses or address ranges. See `ip_set_reference_statement` below for details.
 * @property labelMatchStatement Rule statement that defines a string match search against labels that have been added to the web request by rules that have already run in the web ACL. See `label_match_statement` below for details.
 * @property notStatement Logical rule statement used to negate the results of another rule statement. See `not_statement` below for details.
 * @property orStatement Logical rule statement used to combine other rule statements with OR logic. See `or_statement` below for details.
 * @property regexMatchStatement Rule statement used to search web request components for a match against a single regular expression. See `regex_match_statement` below for details.
 * @property regexPatternSetReferenceStatement Rule statement used to search web request components for matches with regular expressions. See `regex_pattern_set_reference_statement` below for details.
 * @property sizeConstraintStatement Rule statement that compares a number of bytes against the size of a request component, using a comparison operator, such as greater than (>) or less than (<). See `size_constraint_statement` below for more details.
 * @property sqliMatchStatement An SQL injection match condition identifies the part of web requests, such as the URI or the query string, that you want AWS WAF to inspect. See `sqli_match_statement` below for details.
 * @property xssMatchStatement Rule statement that defines a cross-site scripting (XSS) match search for AWS WAF to apply to web requests. See `xss_match_statement` below for details.
 */
public data class WebAclRuleStatementRateBasedStatementScopeDownStatement(
    public val andStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatement? =
        null,
    public val byteMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement? = null,
    public val geoMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement? = null,
    public val ipSetReferenceStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatement? = null,
    public val labelMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatement? = null,
    public val notStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatement? =
        null,
    public val orStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatement? =
        null,
    public val regexMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatement? = null,
    public val regexPatternSetReferenceStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatement? =
        null,
    public val sizeConstraintStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatement? = null,
    public val sqliMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement? = null,
    public val xssMatchStatement: WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatement? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatement): WebAclRuleStatementRateBasedStatementScopeDownStatement =
            WebAclRuleStatementRateBasedStatementScopeDownStatement(
                andStatement = javaType.andStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementAndStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                byteMatchStatement = javaType.byteMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementByteMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                geoMatchStatement = javaType.geoMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementGeoMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ipSetReferenceStatement = javaType.ipSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementIpSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                labelMatchStatement = javaType.labelMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementLabelMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                notStatement = javaType.notStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementNotStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                orStatement = javaType.orStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementOrStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexMatchStatement = javaType.regexMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                regexPatternSetReferenceStatement = javaType.regexPatternSetReferenceStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementRegexPatternSetReferenceStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sizeConstraintStatement = javaType.sizeConstraintStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSizeConstraintStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                sqliMatchStatement = javaType.sqliMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementSqliMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                xssMatchStatement = javaType.xssMatchStatement().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRateBasedStatementScopeDownStatementXssMatchStatement.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
