@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headerOrders Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatch(
    public val allQueryArguments: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArguments? = null,
    public val body: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBody? = null,
    public val cookies: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookies? =
        null,
    public val headerOrders: List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrder>? = null,
    public val headers: List<WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeader>? =
        null,
    public val ja3Fingerprint: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3Fingerprint? = null,
    public val jsonBody: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBody? =
        null,
    public val method: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethod? = null,
    public val queryString: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryString? = null,
    public val singleHeader: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeader? = null,
    public val singleQueryArgument: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgument? = null,
    public val uriPath: WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPath? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatch): WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatch =
            WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headerOrders = javaType.headerOrders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeaderOrder.Companion.toKotlin(args0)
                    })
                }),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRegexPatternSetReferenceStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
