@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the `aws.wafv2.RuleGroup` resource.
 * @property ruleActionOverrides Action settings to use in the place of the rule actions that are configured inside the rule group. You specify one override for each rule whose action you want to change. See `rule_action_override` below for details.
 */
public data class WebAclRuleStatementRuleGroupReferenceStatement(
    public val arn: String,
    public val ruleActionOverrides: List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRuleGroupReferenceStatement): WebAclRuleStatementRuleGroupReferenceStatement =
            WebAclRuleStatementRuleGroupReferenceStatement(
                arn = javaType.arn(),
                ruleActionOverrides = javaType.ruleActionOverrides().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
