@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actionToUse Override action to use, in place of the configured action of the rule in the rule group. See `action` for details.
 * @property name Name of the rule to override. See the [documentation](https://docs.aws.amazon.com/waf/latest/developerguide/aws-managed-rule-groups-list.html) for a list of names in the appropriate rule group in use.
 */
public data class WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride(
    public val actionToUse: WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUse,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride): WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverride(
                actionToUse = javaType.actionToUse().let({ args0 ->
                    com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUse.Companion.toKotlin(args0)
                }),
                name = javaType.name(),
            )
    }
}
