@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property customResponseBodyKey References the response body that you want AWS WAF to return to the web request client. This must reference a `key` defined in a `custom_response_body` block of this resource.
 * @property responseCode The HTTP status code to return to the client.
 * @property responseHeaders The `response_header` blocks used to define the HTTP response headers added to the response. See `response_header` below for details.
 */
public data class
WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponse(
    public val customResponseBodyKey: String? = null,
    public val responseCode: Int,
    public val responseHeaders: List<WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeader>? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponse): WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponse =
            WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponse(
                customResponseBodyKey = javaType.customResponseBodyKey().map({ args0 -> args0 }).orElse(null),
                responseCode = javaType.responseCode(),
                responseHeaders = javaType.responseHeaders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementRuleGroupReferenceStatementRuleActionOverrideActionToUseBlockCustomResponseResponseHeader.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
