@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.wafv2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property allQueryArguments Inspect all query arguments.
 * @property body Inspect the request body, which immediately follows the request headers. See `body` below for details.
 * @property cookies Inspect the cookies in the web request. See `cookies` below for details.
 * @property headerOrders Inspect a string containing the list of the request's header names, ordered as they appear in the web request that AWS WAF receives for inspection. See `header_order` below for details.
 * @property headers Inspect the request headers. See `headers` below for details.
 * @property ja3Fingerprint Inspect the JA3 fingerprint. See `ja3_fingerprint` below for details.
 * @property jsonBody Inspect the request body as JSON. See `json_body` for details.
 * @property method Inspect the HTTP method. The method indicates the type of operation that the request is asking the origin to perform.
 * @property queryString Inspect the query string. This is the part of a URL that appears after a `?` character, if any.
 * @property singleHeader Inspect a single header. See `single_header` below for details.
 * @property singleQueryArgument Inspect a single query argument. See `single_query_argument` below for details.
 * @property uriPath Inspect the request URI path. This is the part of a web request that identifies a resource, for example, `/images/daily-ad.jpg`.
 */
public data class WebAclRuleStatementSqliMatchStatementFieldToMatch(
    public val allQueryArguments: WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArguments? =
        null,
    public val body: WebAclRuleStatementSqliMatchStatementFieldToMatchBody? = null,
    public val cookies: WebAclRuleStatementSqliMatchStatementFieldToMatchCookies? = null,
    public val headerOrders: List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderOrder>? =
        null,
    public val headers: List<WebAclRuleStatementSqliMatchStatementFieldToMatchHeader>? = null,
    public val ja3Fingerprint: WebAclRuleStatementSqliMatchStatementFieldToMatchJa3Fingerprint? =
        null,
    public val jsonBody: WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBody? = null,
    public val method: WebAclRuleStatementSqliMatchStatementFieldToMatchMethod? = null,
    public val queryString: WebAclRuleStatementSqliMatchStatementFieldToMatchQueryString? = null,
    public val singleHeader: WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeader? = null,
    public val singleQueryArgument: WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgument? = null,
    public val uriPath: WebAclRuleStatementSqliMatchStatementFieldToMatchUriPath? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.wafv2.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatch): WebAclRuleStatementSqliMatchStatementFieldToMatch =
            WebAclRuleStatementSqliMatchStatementFieldToMatch(
                allQueryArguments = javaType.allQueryArguments().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchAllQueryArguments.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                body = javaType.body().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                cookies = javaType.cookies().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchCookies.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                headerOrders = javaType.headerOrders().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeaderOrder.Companion.toKotlin(args0)
                    })
                }),
                headers = javaType.headers().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchHeader.Companion.toKotlin(args0)
                    })
                }),
                ja3Fingerprint = javaType.ja3Fingerprint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchJa3Fingerprint.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                jsonBody = javaType.jsonBody().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchJsonBody.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                method = javaType.method().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchMethod.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                queryString = javaType.queryString().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchQueryString.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleHeader = javaType.singleHeader().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchSingleHeader.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                singleQueryArgument = javaType.singleQueryArgument().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchSingleQueryArgument.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                uriPath = javaType.uriPath().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.wafv2.kotlin.outputs.WebAclRuleStatementSqliMatchStatementFieldToMatchUriPath.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
