@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.aws.worklink.FleetArgs.builder
import com.pulumi.aws.worklink.kotlin.inputs.FleetIdentityProviderArgs
import com.pulumi.aws.worklink.kotlin.inputs.FleetIdentityProviderArgsBuilder
import com.pulumi.aws.worklink.kotlin.inputs.FleetNetworkArgs
import com.pulumi.aws.worklink.kotlin.inputs.FleetNetworkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.worklink.Fleet("example", {name: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.worklink.Fleet("example", name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WorkLink.Fleet("example", new()
 *     {
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/worklink"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := worklink.NewFleet(ctx, "example", &worklink.FleetArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.FleetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:worklink:Fleet
 *     properties:
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * Network Configuration Usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.worklink.Fleet("example", {
 *     name: "example",
 *     network: {
 *         vpcId: testAwsVpc.id,
 *         subnetIds: [testAwsSubnet&#46;map(__item => __item&#46;id)],
 *         securityGroupIds: [test&#46;id],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.worklink.Fleet("example",
 *     name="example",
 *     network={
 *         "vpc_id": test_aws_vpc["id"],
 *         "subnet_ids": [[__item["id"] for __item in test_aws_subnet]],
 *         "security_group_ids": [test["id"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WorkLink.Fleet("example", new()
 *     {
 *         Name = "example",
 *         Network = new Aws.WorkLink.Inputs.FleetNetworkArgs
 *         {
 *             VpcId = testAwsVpc.Id,
 *             SubnetIds = new[]
 *             {
 *                 testAwsSubnet.Select(__item => __item.Id).ToList(),
 *             },
 *             SecurityGroupIds = new[]
 *             {
 *                 test.Id,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/worklink"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := worklink.NewFleet(ctx, "example", &worklink.FleetArgs{
 * Name: pulumi.String("example"),
 * Network: &worklink.FleetNetworkArgs{
 * VpcId: pulumi.Any(testAwsVpc.Id),
 * SubnetIds: pulumi.StringArray{
 * pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:4,25-44)),
 * },
 * SecurityGroupIds: pulumi.StringArray{
 * test.Id,
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.FleetArgs;
 * import com.pulumi.aws.worklink.inputs.FleetNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .name("example")
 *             .network(FleetNetworkArgs.builder()
 *                 .vpcId(testAwsVpc.id())
 *                 .subnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .securityGroupIds(test.id())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * Identity Provider Configuration Usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const test = new aws.worklink.Fleet("test", {
 *     name: "tf-worklink-fleet",
 *     identityProvider: {
 *         type: "SAML",
 *         samlMetadata: std.file({
 *             input: "saml-metadata.xml",
 *         }).then(invoke => invoke.result),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * test = aws.worklink.Fleet("test",
 *     name="tf-worklink-fleet",
 *     identity_provider={
 *         "type": "SAML",
 *         "saml_metadata": std.file(input="saml-metadata.xml").result,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.WorkLink.Fleet("test", new()
 *     {
 *         Name = "tf-worklink-fleet",
 *         IdentityProvider = new Aws.WorkLink.Inputs.FleetIdentityProviderArgs
 *         {
 *             Type = "SAML",
 *             SamlMetadata = Std.File.Invoke(new()
 *             {
 *                 Input = "saml-metadata.xml",
 *             }).Apply(invoke => invoke.Result),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/worklink"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "saml-metadata.xml",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = worklink.NewFleet(ctx, "test", &worklink.FleetArgs{
 * 			Name: pulumi.String("tf-worklink-fleet"),
 * 			IdentityProvider: &worklink.FleetIdentityProviderArgs{
 * 				Type:         pulumi.String("SAML"),
 * 				SamlMetadata: pulumi.String(invokeFile.Result),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.FleetArgs;
 * import com.pulumi.aws.worklink.inputs.FleetIdentityProviderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Fleet("test", FleetArgs.builder()
 *             .name("tf-worklink-fleet")
 *             .identityProvider(FleetIdentityProviderArgs.builder()
 *                 .type("SAML")
 *                 .samlMetadata(StdFunctions.file(FileArgs.builder()
 *                     .input("saml-metadata.xml")
 *                     .build()).result())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:worklink:Fleet
 *     properties:
 *       name: tf-worklink-fleet
 *       identityProvider:
 *         type: SAML
 *         samlMetadata:
 *           fn::invoke:
 *             Function: std:file
 *             Arguments:
 *               input: saml-metadata.xml
 *             Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WorkLink using the ARN. For example:
 * ```sh
 * $ pulumi import aws:worklink/fleet:Fleet test arn:aws:worklink::123456789012:fleet/example
 * ```
 * @property auditStreamArn The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
 * @property deviceCaCertificate The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
 * @property displayName The name of the fleet.
 * @property identityProvider Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
 * @property name A region-unique name for the AMI.
 * @property network Provide this to allow manage the company network configuration for the fleet. Fields documented below.
 * @property optimizeForEndUserLocation The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
 * **network** requires the following:
 * > **NOTE:** `network` is cannot removed without force recreating.
 */
public data class FleetArgs(
    public val auditStreamArn: Output<String>? = null,
    public val deviceCaCertificate: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val identityProvider: Output<FleetIdentityProviderArgs>? = null,
    public val name: Output<String>? = null,
    public val network: Output<FleetNetworkArgs>? = null,
    public val optimizeForEndUserLocation: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.worklink.FleetArgs> {
    override fun toJava(): com.pulumi.aws.worklink.FleetArgs =
        com.pulumi.aws.worklink.FleetArgs.builder()
            .auditStreamArn(auditStreamArn?.applyValue({ args0 -> args0 }))
            .deviceCaCertificate(deviceCaCertificate?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identityProvider(identityProvider?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .network(network?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .optimizeForEndUserLocation(optimizeForEndUserLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetArgs].
 */
@PulumiTagMarker
public class FleetArgsBuilder internal constructor() {
    private var auditStreamArn: Output<String>? = null

    private var deviceCaCertificate: Output<String>? = null

    private var displayName: Output<String>? = null

    private var identityProvider: Output<FleetIdentityProviderArgs>? = null

    private var name: Output<String>? = null

    private var network: Output<FleetNetworkArgs>? = null

    private var optimizeForEndUserLocation: Output<Boolean>? = null

    /**
     * @param value The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
     */
    @JvmName("ycjutkxvesiepect")
    public suspend fun auditStreamArn(`value`: Output<String>) {
        this.auditStreamArn = value
    }

    /**
     * @param value The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
     */
    @JvmName("wotalbpwpfuobogs")
    public suspend fun deviceCaCertificate(`value`: Output<String>) {
        this.deviceCaCertificate = value
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("yhldlhmlbnqagjwx")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("kckukypntggkppca")
    public suspend fun identityProvider(`value`: Output<FleetIdentityProviderArgs>) {
        this.identityProvider = value
    }

    /**
     * @param value A region-unique name for the AMI.
     */
    @JvmName("lswljuxwdjwesmjc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("guochynyysqasxwa")
    public suspend fun network(`value`: Output<FleetNetworkArgs>) {
        this.network = value
    }

    /**
     * @param value The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
     * **network** requires the following:
     * > **NOTE:** `network` is cannot removed without force recreating.
     */
    @JvmName("wyjlcrnilybirwrc")
    public suspend fun optimizeForEndUserLocation(`value`: Output<Boolean>) {
        this.optimizeForEndUserLocation = value
    }

    /**
     * @param value The ARN of the Amazon Kinesis data stream that receives the audit events. Kinesis data stream name must begin with `"AmazonWorkLink-"`.
     */
    @JvmName("tamgbqykmxifbplv")
    public suspend fun auditStreamArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditStreamArn = mapped
    }

    /**
     * @param value The certificate chain, including intermediate certificates and the root certificate authority certificate used to issue device certificates.
     */
    @JvmName("mqpwrcndrnsrprys")
    public suspend fun deviceCaCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceCaCertificate = mapped
    }

    /**
     * @param value The name of the fleet.
     */
    @JvmName("vocinwqmcsbacldt")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("uinctpfcnasvoixt")
    public suspend fun identityProvider(`value`: FleetIdentityProviderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityProvider = mapped
    }

    /**
     * @param argument Provide this to allow manage the identity provider configuration for the fleet. Fields documented below.
     */
    @JvmName("hbrlsrnpevumtyuq")
    public suspend fun identityProvider(argument: suspend FleetIdentityProviderArgsBuilder.() -> Unit) {
        val toBeMapped = FleetIdentityProviderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identityProvider = mapped
    }

    /**
     * @param value A region-unique name for the AMI.
     */
    @JvmName("fpdbxtppnhcbalcc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("knwaeadenftbtciy")
    public suspend fun network(`value`: FleetNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.network = mapped
    }

    /**
     * @param argument Provide this to allow manage the company network configuration for the fleet. Fields documented below.
     */
    @JvmName("stgbtroybtqbjojt")
    public suspend fun network(argument: suspend FleetNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = FleetNetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.network = mapped
    }

    /**
     * @param value The option to optimize for better performance by routing traffic through the closest AWS Region to users, which may be outside of your home Region. Defaults to `true`.
     * **network** requires the following:
     * > **NOTE:** `network` is cannot removed without force recreating.
     */
    @JvmName("sfadhlcdqgwjouvf")
    public suspend fun optimizeForEndUserLocation(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optimizeForEndUserLocation = mapped
    }

    internal fun build(): FleetArgs = FleetArgs(
        auditStreamArn = auditStreamArn,
        deviceCaCertificate = deviceCaCertificate,
        displayName = displayName,
        identityProvider = identityProvider,
        name = name,
        network = network,
        optimizeForEndUserLocation = optimizeForEndUserLocation,
    )
}
