@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.worklink.kotlin

import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * import * as std from "@pulumi/std";
 * const example = new aws.worklink.Fleet("example", {name: "example"});
 * const test = new aws.worklink.WebsiteCertificateAuthorityAssociation("test", {
 *     fleetArn: testAwsWorklinkFleet.arn,
 *     certificate: std.file({
 *         input: "certificate.pem",
 *     }).then(invoke => invoke.result),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * import pulumi_std as std
 * example = aws.worklink.Fleet("example", name="example")
 * test = aws.worklink.WebsiteCertificateAuthorityAssociation("test",
 *     fleet_arn=test_aws_worklink_fleet["arn"],
 *     certificate=std.file(input="certificate.pem").result)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * using Std = Pulumi.Std;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.WorkLink.Fleet("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var test = new Aws.WorkLink.WebsiteCertificateAuthorityAssociation("test", new()
 *     {
 *         FleetArn = testAwsWorklinkFleet.Arn,
 *         Certificate = Std.File.Invoke(new()
 *         {
 *             Input = "certificate.pem",
 *         }).Apply(invoke => invoke.Result),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/worklink"
 * 	"github.com/pulumi/pulumi-std/sdk/go/std"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := worklink.NewFleet(ctx, "example", &worklink.FleetArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		invokeFile, err := std.File(ctx, &std.FileArgs{
 * 			Input: "certificate.pem",
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = worklink.NewWebsiteCertificateAuthorityAssociation(ctx, "test", &worklink.WebsiteCertificateAuthorityAssociationArgs{
 * 			FleetArn:    pulumi.Any(testAwsWorklinkFleet.Arn),
 * 			Certificate: pulumi.String(invokeFile.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.worklink.Fleet;
 * import com.pulumi.aws.worklink.FleetArgs;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociation;
 * import com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Fleet("example", FleetArgs.builder()
 *             .name("example")
 *             .build());
 *         var test = new WebsiteCertificateAuthorityAssociation("test", WebsiteCertificateAuthorityAssociationArgs.builder()
 *             .fleetArn(testAwsWorklinkFleet.arn())
 *             .certificate(StdFunctions.file(FileArgs.builder()
 *                 .input("certificate.pem")
 *                 .build()).result())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:worklink:Fleet
 *     properties:
 *       name: example
 *   test:
 *     type: aws:worklink:WebsiteCertificateAuthorityAssociation
 *     properties:
 *       fleetArn: ${testAwsWorklinkFleet.arn}
 *       certificate:
 *         fn::invoke:
 *           Function: std:file
 *           Arguments:
 *             input: certificate.pem
 *           Return: result
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import WorkLink Website Certificate Authority using `FLEET-ARN,WEBSITE-CA-ID`. For example:
 * ```sh
 * $ pulumi import aws:worklink/websiteCertificateAuthorityAssociation:WebsiteCertificateAuthorityAssociation example arn:aws:worklink::123456789012:fleet/example,abcdefghijk
 * ```
 * @property certificate The root certificate of the Certificate Authority.
 * @property displayName The certificate name to display.
 * @property fleetArn The ARN of the fleet.
 */
public data class WebsiteCertificateAuthorityAssociationArgs(
    public val certificate: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val fleetArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs> {
    override fun toJava(): com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs =
        com.pulumi.aws.worklink.WebsiteCertificateAuthorityAssociationArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .fleetArn(fleetArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WebsiteCertificateAuthorityAssociationArgs].
 */
@PulumiTagMarker
public class WebsiteCertificateAuthorityAssociationArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var displayName: Output<String>? = null

    private var fleetArn: Output<String>? = null

    /**
     * @param value The root certificate of the Certificate Authority.
     */
    @JvmName("bdxgmjqefktavtbg")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value The certificate name to display.
     */
    @JvmName("kulrkhvykwxjplnv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The ARN of the fleet.
     */
    @JvmName("wlejmusbejjqapfk")
    public suspend fun fleetArn(`value`: Output<String>) {
        this.fleetArn = value
    }

    /**
     * @param value The root certificate of the Certificate Authority.
     */
    @JvmName("mbyxoxnbknrsluyl")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value The certificate name to display.
     */
    @JvmName("nvwrgipsvemkptkb")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The ARN of the fleet.
     */
    @JvmName("mnnwaekfkoqoyenb")
    public suspend fun fleetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fleetArn = mapped
    }

    internal fun build(): WebsiteCertificateAuthorityAssociationArgs =
        WebsiteCertificateAuthorityAssociationArgs(
            certificate = certificate,
            displayName = displayName,
            fleetArn = fleetArn,
        )
}
